/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client;

import com.rabbitmq.qpid.protonj2.client.Delivery;
import com.rabbitmq.qpid.protonj2.client.LinkOptions;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ReceiverOptions
extends LinkOptions<ReceiverOptions>
implements Cloneable {
    private long drainTimeout = 60000L;
    private boolean autoAccept = true;
    private int creditWindow = 10;
    private Consumer<Delivery> handler;
    private Consumer<ClientException> closeHandler;

    public ReceiverOptions() {
    }

    public ReceiverOptions(ReceiverOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    public ReceiverOptions autoAccept(boolean autoAccept) {
        this.autoAccept = autoAccept;
        return this;
    }

    public boolean autoAccept() {
        return this.autoAccept;
    }

    public int creditWindow() {
        return this.creditWindow;
    }

    public ReceiverOptions creditWindow(int creditWindow) {
        this.creditWindow = creditWindow;
        return this;
    }

    public long drainTimeout() {
        return this.drainTimeout;
    }

    public ReceiverOptions drainTimeout(long drainTimeout) {
        return this.drainTimeout(drainTimeout, TimeUnit.MILLISECONDS);
    }

    public ReceiverOptions drainTimeout(long timeout, TimeUnit units) {
        this.drainTimeout = units.toMillis(timeout);
        return this;
    }

    public ReceiverOptions handler(Consumer<Delivery> handler) {
        this.handler = handler;
        return this;
    }

    public Consumer<Delivery> handler() {
        return this.handler;
    }

    public ReceiverOptions closeHandler(Consumer<ClientException> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    public Consumer<ClientException> closeHandler() {
        return this.closeHandler;
    }

    public ReceiverOptions clone() {
        return this.copyInto(new ReceiverOptions());
    }

    protected ReceiverOptions copyInto(ReceiverOptions other) {
        super.copyInto(other);
        other.autoAccept(this.autoAccept);
        other.creditWindow(this.creditWindow);
        other.drainTimeout(this.drainTimeout);
        other.handler(this.handler);
        other.closeHandler(this.closeHandler);
        return other;
    }

    @Override
    protected ReceiverOptions self() {
        return this;
    }
}

