/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.client.DeliveryState;
import com.rabbitmq.qpid.protonj2.client.DistributionMode;
import com.rabbitmq.qpid.protonj2.client.DurabilityMode;
import com.rabbitmq.qpid.protonj2.client.ExpiryPolicy;
import com.rabbitmq.qpid.protonj2.client.Source;
import com.rabbitmq.qpid.protonj2.client.impl.ClientConversionSupport;
import com.rabbitmq.qpid.protonj2.client.impl.ClientDeliveryState;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class ClientRemoteSource
implements Source {
    private final com.rabbitmq.qpid.protonj2.types.messaging.Source remoteSource;
    private DeliveryState cachedDefaultOutcome;
    private DistributionMode cachedDistributionMode;
    private Map<String, Object> cachedDynamicNodeProperties;
    private Map<String, String> cachedFilters;
    private Set<DeliveryState.Type> cachedOutcomes;
    private Set<String> cachedCapabilities;

    ClientRemoteSource(com.rabbitmq.qpid.protonj2.types.messaging.Source remoteSource) {
        this.remoteSource = remoteSource;
    }

    @Override
    public String address() {
        return this.remoteSource.getAddress();
    }

    @Override
    public DurabilityMode durabilityMode() {
        if (this.remoteSource.getDurable() != null) {
            switch (this.remoteSource.getDurable()) {
                case NONE: {
                    return DurabilityMode.NONE;
                }
                case CONFIGURATION: {
                    return DurabilityMode.CONFIGURATION;
                }
                case UNSETTLED_STATE: {
                    return DurabilityMode.UNSETTLED_STATE;
                }
            }
        }
        return DurabilityMode.NONE;
    }

    @Override
    public long timeout() {
        return this.remoteSource.getTimeout() == null ? 0L : this.remoteSource.getTimeout().longValue();
    }

    @Override
    public ExpiryPolicy expiryPolicy() {
        if (this.remoteSource.getExpiryPolicy() != null) {
            switch (this.remoteSource.getExpiryPolicy()) {
                case LINK_DETACH: {
                    return ExpiryPolicy.LINK_CLOSE;
                }
                case SESSION_END: {
                    return ExpiryPolicy.SESSION_CLOSE;
                }
                case CONNECTION_CLOSE: {
                    return ExpiryPolicy.CONNECTION_CLOSE;
                }
                case NEVER: {
                    return ExpiryPolicy.NEVER;
                }
            }
        }
        return ExpiryPolicy.SESSION_CLOSE;
    }

    @Override
    public boolean dynamic() {
        return this.remoteSource.isDynamic();
    }

    @Override
    public Map<String, Object> dynamicNodeProperties() {
        if (this.cachedDynamicNodeProperties == null && this.remoteSource.getDynamicNodeProperties() != null) {
            this.cachedDynamicNodeProperties = Collections.unmodifiableMap(ClientConversionSupport.toStringKeyedMap(this.remoteSource.getDynamicNodeProperties()));
        }
        return this.cachedDynamicNodeProperties;
    }

    @Override
    public DistributionMode distributionMode() {
        if (this.cachedDistributionMode == null && this.remoteSource.getDistributionMode() != null) {
            switch (this.remoteSource.getDistributionMode().toString()) {
                case "MOVE": {
                    this.cachedDistributionMode = DistributionMode.MOVE;
                    break;
                }
                case "COPY": {
                    this.cachedDistributionMode = DistributionMode.COPY;
                    break;
                }
            }
        }
        return this.cachedDistributionMode;
    }

    @Override
    public Map<String, String> filters() {
        if (this.cachedFilters == null && this.remoteSource.getFilter() != null) {
            this.cachedFilters = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> result = this.cachedFilters;
            this.remoteSource.getFilter().forEach((key, value) -> result.put(key.toString(), value.toString()));
        }
        return this.cachedFilters;
    }

    @Override
    public DeliveryState defaultOutcome() {
        if (this.cachedDefaultOutcome == null && this.remoteSource.getDefaultOutcome() != null) {
            this.cachedDefaultOutcome = ClientDeliveryState.fromProtonType(this.remoteSource.getDefaultOutcome());
        }
        return this.cachedDefaultOutcome;
    }

    @Override
    public Set<DeliveryState.Type> outcomes() {
        if (this.cachedOutcomes == null && this.remoteSource.getOutcomes() != null) {
            this.cachedOutcomes = new LinkedHashSet<DeliveryState.Type>(this.remoteSource.getOutcomes().length);
            for (Symbol outcomeName : this.remoteSource.getOutcomes()) {
                this.cachedOutcomes.add(ClientDeliveryState.fromOutcomeSymbol(outcomeName));
            }
            this.cachedOutcomes = Collections.unmodifiableSet(this.cachedOutcomes);
        }
        return this.cachedOutcomes;
    }

    @Override
    public Set<String> capabilities() {
        if (this.cachedCapabilities == null && this.remoteSource.getCapabilities() != null) {
            this.cachedCapabilities = Collections.unmodifiableSet(ClientConversionSupport.toStringSet(this.remoteSource.getCapabilities()));
        }
        return this.cachedCapabilities;
    }
}

