/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.client.LinkOptions;
import com.rabbitmq.qpid.protonj2.client.SenderOptions;
import com.rabbitmq.qpid.protonj2.client.SessionOptions;
import com.rabbitmq.qpid.protonj2.client.SourceOptions;
import com.rabbitmq.qpid.protonj2.client.StreamSenderOptions;
import com.rabbitmq.qpid.protonj2.client.TargetOptions;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.impl.ClientConversionSupport;
import com.rabbitmq.qpid.protonj2.client.impl.ClientDeliveryState;
import com.rabbitmq.qpid.protonj2.client.impl.ClientSender;
import com.rabbitmq.qpid.protonj2.client.impl.ClientSession;
import com.rabbitmq.qpid.protonj2.client.impl.ClientStreamSender;
import com.rabbitmq.qpid.protonj2.engine.DeliveryTagGenerator;
import com.rabbitmq.qpid.protonj2.engine.Sender;
import com.rabbitmq.qpid.protonj2.engine.Session;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonDeliveryTagGenerator;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.messaging.Outcome;
import com.rabbitmq.qpid.protonj2.types.messaging.Source;
import com.rabbitmq.qpid.protonj2.types.messaging.Target;
import com.rabbitmq.qpid.protonj2.types.messaging.TerminusDurability;
import com.rabbitmq.qpid.protonj2.types.messaging.TerminusExpiryPolicy;
import com.rabbitmq.qpid.protonj2.types.transactions.Coordinator;
import com.rabbitmq.qpid.protonj2.types.transport.ReceiverSettleMode;
import com.rabbitmq.qpid.protonj2.types.transport.SenderSettleMode;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

final class ClientSenderBuilder {
    private final ClientSession session;
    private final SessionOptions sessionOptions;
    private final AtomicInteger senderCounter = new AtomicInteger();
    private volatile SenderOptions defaultSenderOptions;
    private volatile StreamSenderOptions defaultStreamSenderOptions;

    ClientSenderBuilder(ClientSession session) {
        this.session = session;
        this.sessionOptions = session.options();
    }

    public ClientSender sender(String address, SenderOptions senderOptions) throws ClientException {
        SenderOptions options = senderOptions != null ? senderOptions : this.getDefaultSenderOptions();
        String senderId = this.nextSenderId();
        DeliveryTagGenerator tagGenerator = options.deliveryTagGeneratorSupplier() == null ? null : Objects.requireNonNull(options.deliveryTagGeneratorSupplier().get(), "Cannot assign a null tag generator from a custom supplier");
        Sender protonSender = ClientSenderBuilder.createSender(this.session.getProtonSession(), address, options, senderId, tagGenerator);
        return new ClientSender(this.session, options, senderId, protonSender);
    }

    public ClientSender anonymousSender(SenderOptions senderOptions) throws ClientException {
        SenderOptions options = senderOptions != null ? senderOptions : this.getDefaultSenderOptions();
        String senderId = this.nextSenderId();
        DeliveryTagGenerator tagGenerator = options.deliveryTagGeneratorSupplier() == null ? null : Objects.requireNonNull(options.deliveryTagGeneratorSupplier().get(), "Cannot assign a null tag generator from a custom supplier");
        Sender protonSender = ClientSenderBuilder.createSender(this.session.getProtonSession(), null, options, senderId, tagGenerator);
        return new ClientSender(this.session, options, senderId, protonSender);
    }

    public ClientStreamSender streamSender(String address, StreamSenderOptions senderOptions) throws ClientException {
        StreamSenderOptions options = senderOptions != null ? senderOptions : this.getDefaultStreamSenderOptions();
        String senderId = this.nextSenderId();
        DeliveryTagGenerator tagGenerator = options.deliveryTagGeneratorSupplier() == null ? null : Objects.requireNonNull(options.deliveryTagGeneratorSupplier().get(), "Cannot assign a null tag generator from a custom supplier");
        Sender protonSender = ClientSenderBuilder.createSender(this.session.getProtonSession(), address, options, senderId, tagGenerator);
        return new ClientStreamSender(this.session, options, senderId, protonSender);
    }

    private static Sender createSender(Session protonSession, String address, LinkOptions<?> options, String senderId, DeliveryTagGenerator tagGenerator) {
        Object linkName = options.linkName() != null ? options.linkName() : "sender-" + senderId;
        Sender protonSender = protonSession.sender((String)linkName);
        switch (options.deliveryMode()) {
            case AT_MOST_ONCE: {
                protonSender.setSenderSettleMode(SenderSettleMode.SETTLED);
                protonSender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                break;
            }
            case AT_LEAST_ONCE: {
                protonSender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                protonSender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            }
        }
        protonSender.setOfferedCapabilities(ClientConversionSupport.toSymbolArray(options.offeredCapabilities()));
        protonSender.setDesiredCapabilities(ClientConversionSupport.toSymbolArray(options.desiredCapabilities()));
        protonSender.setProperties(ClientConversionSupport.toSymbolKeyedMap(options.properties()));
        protonSender.setTarget(ClientSenderBuilder.createTarget(address, options));
        protonSender.setSource(ClientSenderBuilder.createSource(address, options));
        if (tagGenerator == null) {
            if (protonSender.getSenderSettleMode() == SenderSettleMode.SETTLED) {
                protonSender.setDeliveryTagGenerator(ProtonDeliveryTagGenerator.BUILTIN.EMPTY.createGenerator());
            } else {
                protonSender.setDeliveryTagGenerator(ProtonDeliveryTagGenerator.BUILTIN.POOLED.createGenerator());
            }
        } else {
            protonSender.setDeliveryTagGenerator(tagGenerator);
        }
        return protonSender;
    }

    private static Source createSource(String address, LinkOptions<?> options) {
        SourceOptions sourceOptions = options.sourceOptions();
        Source source = new Source();
        source.setAddress(address);
        source.setOutcomes(ClientConversionSupport.outcomesToSymbols(sourceOptions.outcomes()));
        source.setDefaultOutcome((Outcome)((Object)ClientDeliveryState.asProtonType(sourceOptions.defaultOutcome())));
        source.setCapabilities(ClientConversionSupport.toSymbolArray(sourceOptions.capabilities()));
        if (sourceOptions.timeout() >= 0L) {
            source.setTimeout(UnsignedInteger.valueOf(sourceOptions.timeout()));
        }
        if (sourceOptions.durabilityMode() != null) {
            source.setDurable(ClientConversionSupport.asProtonType(sourceOptions.durabilityMode()));
        } else {
            source.setDurable(TerminusDurability.NONE);
        }
        if (sourceOptions.expiryPolicy() != null) {
            source.setExpiryPolicy(ClientConversionSupport.asProtonType(sourceOptions.expiryPolicy()));
        } else {
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        }
        if (sourceOptions.distributionMode() != null) {
            source.setDistributionMode(ClientConversionSupport.asProtonType(sourceOptions.distributionMode()));
        }
        if (sourceOptions.timeout() >= 0L) {
            source.setTimeout(UnsignedInteger.valueOf(sourceOptions.timeout()));
        }
        if (sourceOptions.filters() != null) {
            source.setFilter(ClientConversionSupport.toSymbolKeyedMap(sourceOptions.filters()));
        }
        return source;
    }

    private static Target createTarget(String address, LinkOptions<?> options) {
        TargetOptions targetOptions = options.targetOptions();
        Target target = new Target();
        target.setAddress(address);
        target.setCapabilities(ClientConversionSupport.toSymbolArray(targetOptions.capabilities()));
        if (targetOptions.durabilityMode() != null) {
            target.setDurable(ClientConversionSupport.asProtonType(targetOptions.durabilityMode()));
        }
        if (targetOptions.expiryPolicy() != null) {
            target.setExpiryPolicy(ClientConversionSupport.asProtonType(targetOptions.expiryPolicy()));
        }
        if (targetOptions.timeout() >= 0L) {
            target.setTimeout(UnsignedInteger.valueOf(targetOptions.timeout()));
        }
        return target;
    }

    public static Sender recreateSender(ClientSession session, Sender previousSender, LinkOptions<?> options) {
        Sender protonSender = session.getProtonSession().sender(previousSender.getName());
        protonSender.setSource(previousSender.getSource());
        if (previousSender.getTarget() instanceof Coordinator) {
            protonSender.setTarget((Coordinator)previousSender.getTarget());
        } else {
            protonSender.setTarget((Target)previousSender.getTarget());
        }
        protonSender.setDeliveryTagGenerator(previousSender.getDeliveryTagGenerator());
        protonSender.setSenderSettleMode(previousSender.getSenderSettleMode());
        protonSender.setReceiverSettleMode(previousSender.getReceiverSettleMode());
        protonSender.setOfferedCapabilities(ClientConversionSupport.toSymbolArray(options.offeredCapabilities()));
        protonSender.setDesiredCapabilities(ClientConversionSupport.toSymbolArray(options.desiredCapabilities()));
        protonSender.setProperties(ClientConversionSupport.toSymbolKeyedMap(options.properties()));
        return protonSender;
    }

    private String nextSenderId() {
        return this.session.id() + ":" + this.senderCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SenderOptions getDefaultSenderOptions() {
        SenderOptions senderOptions = this.defaultSenderOptions;
        if (senderOptions == null) {
            ClientSenderBuilder clientSenderBuilder = this;
            synchronized (clientSenderBuilder) {
                senderOptions = this.defaultSenderOptions;
                if (senderOptions == null) {
                    senderOptions = new SenderOptions();
                    senderOptions.openTimeout(this.sessionOptions.openTimeout());
                    senderOptions.closeTimeout(this.sessionOptions.closeTimeout());
                    senderOptions.requestTimeout(this.sessionOptions.requestTimeout());
                    senderOptions.sendTimeout(this.sessionOptions.sendTimeout());
                }
                this.defaultSenderOptions = senderOptions;
            }
        }
        return senderOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSenderOptions getDefaultStreamSenderOptions() {
        StreamSenderOptions senderOptions = this.defaultStreamSenderOptions;
        if (senderOptions == null) {
            ClientSenderBuilder clientSenderBuilder = this;
            synchronized (clientSenderBuilder) {
                senderOptions = this.defaultStreamSenderOptions;
                if (senderOptions == null) {
                    senderOptions = new StreamSenderOptions();
                    senderOptions.openTimeout(this.sessionOptions.openTimeout());
                    senderOptions.closeTimeout(this.sessionOptions.closeTimeout());
                    senderOptions.requestTimeout(this.sessionOptions.requestTimeout());
                    senderOptions.sendTimeout(this.sessionOptions.sendTimeout());
                }
                this.defaultStreamSenderOptions = senderOptions;
            }
        }
        return senderOptions;
    }
}

