/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.client.DeliveryState;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientDeliveryStateException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import com.rabbitmq.qpid.protonj2.client.impl.ClientDeliveryState;
import com.rabbitmq.qpid.protonj2.client.impl.ClientExceptionSupport;
import com.rabbitmq.qpid.protonj2.client.impl.ClientSenderLinkType;
import com.rabbitmq.qpid.protonj2.engine.OutgoingDelivery;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class ClientTrackable<SenderType extends ClientSenderLinkType<?>, TrackerType> {
    protected final SenderType sender;
    protected final OutgoingDelivery delivery;
    protected static final AtomicIntegerFieldUpdater<ClientTrackable> REMOTELY_SETTLED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ClientTrackable.class, "remotelySettled");
    protected static final AtomicReferenceFieldUpdater<ClientTrackable, DeliveryState> REMOTEL_DELIVERY_STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ClientTrackable.class, DeliveryState.class, "remoteDeliveryState");
    private final CompletableFuture<TrackerType> remoteSettlementFuture;
    private volatile int remotelySettled;
    private volatile DeliveryState remoteDeliveryState;

    ClientTrackable(SenderType sender, OutgoingDelivery delivery) {
        Objects.requireNonNull(sender, "Sender cannot be null for a Tracker");
        this.remoteSettlementFuture = new CompletableFuture();
        this.sender = sender;
        this.delivery = delivery;
        this.delivery.deliveryStateUpdatedHandler(this::processDeliveryUpdated);
    }

    protected abstract TrackerType self();

    OutgoingDelivery delivery() {
        return this.delivery;
    }

    public synchronized DeliveryState state() {
        return ClientDeliveryState.fromProtonType(this.delivery.getState());
    }

    public DeliveryState remoteState() {
        return this.remoteDeliveryState;
    }

    public boolean remoteSettled() {
        return this.remotelySettled > 0;
    }

    public TrackerType disposition(DeliveryState state, boolean settle) throws ClientException {
        try {
            ((ClientSenderLinkType)this.sender).disposition(this.delivery, ClientDeliveryState.asProtonType(state), settle);
        }
        finally {
            if (settle) {
                this.remoteSettlementFuture.complete(this.self());
            }
        }
        return this.self();
    }

    public TrackerType settle() throws ClientException {
        try {
            ((ClientSenderLinkType)this.sender).disposition(this.delivery, null, true);
        }
        finally {
            this.remoteSettlementFuture.complete(this.self());
        }
        return this.self();
    }

    public synchronized boolean settled() {
        return this.delivery.isSettled();
    }

    public CompletableFuture<TrackerType> settlementFuture() {
        if (this.delivery.isSettled() || this.remoteSettled()) {
            this.remoteSettlementFuture.complete(this.self());
        }
        return this.remoteSettlementFuture;
    }

    public TrackerType awaitSettlement() throws ClientException {
        try {
            if (this.settled()) {
                return this.self();
            }
            return this.settlementFuture().get();
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ClientException("Wait for settlement was interrupted", e);
        }
    }

    public TrackerType awaitSettlement(long timeout, TimeUnit unit) throws ClientException {
        try {
            if (this.settled()) {
                return this.self();
            }
            return this.settlementFuture().get(timeout, unit);
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ClientException("Wait for settlement was interrupted", ie);
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (TimeoutException te) {
            throw new ClientOperationTimedOutException("Timed out waiting for remote settlement", te);
        }
    }

    public TrackerType awaitAccepted() throws ClientException {
        try {
            if (this.settled() && !this.remoteSettled()) {
                return this.self();
            }
            this.settlementFuture().get();
            if (this.remoteState() != null && this.remoteState().isAccepted()) {
                return this.self();
            }
            throw new ClientDeliveryStateException("Remote did not accept the sent message", this.remoteState());
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ClientException("Wait for Accepted outcome was interrupted", ie);
        }
    }

    public TrackerType awaitAccepted(long timeout, TimeUnit unit) throws ClientException {
        try {
            if (this.settled() && !this.remoteSettled()) {
                return this.self();
            }
            this.settlementFuture().get(timeout, unit);
            if (this.remoteState() != null && this.remoteState().isAccepted()) {
                return this.self();
            }
            throw new ClientDeliveryStateException("Remote did not accept the sent message", this.remoteState());
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ClientException("Wait for Accepted outcome was interrupted", ie);
        }
        catch (ExecutionException exe) {
            throw ClientExceptionSupport.createNonFatalOrPassthrough(exe.getCause());
        }
        catch (TimeoutException te) {
            throw new ClientOperationTimedOutException("Timed out waiting for remote Accepted outcome", te);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeliveryUpdated(OutgoingDelivery delivery) {
        if (delivery.isRemotelySettled()) {
            ClientTrackable clientTrackable = this;
            synchronized (clientTrackable) {
                REMOTEL_DELIVERY_STATE_UPDATER.lazySet(this, ClientDeliveryState.fromProtonType(delivery.getRemoteState()));
                REMOTELY_SETTLED_UPDATER.lazySet(this, 1);
                if (this.remoteSettlementFuture != null) {
                    this.remoteSettlementFuture.complete(this.self());
                }
            }
            if (((ClientSenderLinkType)this.sender).options.autoSettle()) {
                delivery.settle();
            }
        } else {
            REMOTEL_DELIVERY_STATE_UPDATER.set(this, ClientDeliveryState.fromProtonType(delivery.getRemoteState()));
        }
    }
}

