/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.transport.netty4;

import com.rabbitmq.qpid.protonj2.client.TransportOptions;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.uring.IoUringIoHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUringSupport {
    private static final Logger LOG;
    public static final String NAME = "IO_URING";
    private static final boolean AVAILABLE;
    private static final Class<? extends Channel> SOCKET_CHANNEL_CLASS;

    public static boolean isAvailable(TransportOptions transportOptions) {
        return transportOptions.allowNativeIO() && AVAILABLE;
    }

    public static boolean isAvailable() {
        return AVAILABLE;
    }

    public static EventLoopGroup createGroup(int nThreads, ThreadFactory ioThreadFactory) {
        return new MultiThreadIoEventLoopGroup(nThreads, ioThreadFactory, IoUringIoHandler.newFactory());
    }

    public static Class<? extends Channel> getChannelClass() {
        IOUringSupport.ensureAvailability();
        return SOCKET_CHANNEL_CLASS;
    }

    public static void ensureAvailability() {
        if (!AVAILABLE) {
            throw new UnsupportedOperationException("Netty io_ring support is not enabled because the Netty library indicates it is not present or disabled");
        }
    }

    static {
        Class<?> eventLoopGroup;
        Method isAvailable;
        Class<?> ioUring;
        LOG = LoggerFactory.getLogger(IOUringSupport.class);
        boolean available = false;
        Class<?> socketChannelClass = null;
        try {
            ioUring = Class.forName("io.netty.channel.uring.IoUring");
            isAvailable = ioUring.getDeclaredMethod("isAvailable", null);
            eventLoopGroup = Class.forName("io.netty.channel.MultiThreadIoEventLoopGroup");
            Class<?> ioUringHandler = Class.forName("io.netty.channel.uring.IoUringIoHandler");
            Class<?> ioUringHandlerFactory = Class.forName("io.netty.channel.IoHandlerFactory");
            socketChannelClass = Class.forName("io.netty.channel.uring.IoUringSocketChannel");
            available = (Boolean)isAvailable.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.debug("Unable to enable netty io_uring support due to error", (Throwable)e);
        }
        if (!available) {
            try {
                ioUring = Class.forName("io.netty.incubator.channel.uring.IOUring");
                isAvailable = ioUring.getDeclaredMethod("isAvailable", new Class[0]);
                eventLoopGroup = Class.forName("io.netty.incubator.channel.uring.IOUringEventLoopGroup");
                socketChannelClass = Class.forName("io.netty.incubator.channel.uring.IOUringSocketChannel");
                available = (Boolean)isAvailable.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOG.debug("Unable to enable netty incubator io_uring support due to error", (Throwable)e);
            }
        }
        AVAILABLE = available;
        SOCKET_CHANNEL_CLASS = socketChannelClass;
    }
}

