/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.transport.netty4;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.client.SslOptions;
import com.rabbitmq.qpid.protonj2.client.TransportOptions;
import com.rabbitmq.qpid.protonj2.client.transport.netty4.TcpTransport;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends TcpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketTransport.class);
    private static final String AMQP_SUB_PROTOCOL = "amqp";
    private ScheduledFuture<?> handshakeTimeoutFuture;

    public WebSocketTransport(Bootstrap bootstrap, TransportOptions options, SslOptions sslOptions) {
        super(bootstrap, options, sslOptions);
    }

    @Override
    public WebSocketTransport write(ProtonBuffer output, final Runnable onComplete) throws IOException {
        this.checkConnected();
        int length = output.getReadableBytes();
        if (length == 0) {
            return this;
        }
        LOG.trace("Attempted write of: {} bytes", (Object)length);
        if (onComplete == null) {
            this.channel.write((Object)new BinaryWebSocketFrame(this.toOutputBuffer(output)), this.channel.voidPromise());
        } else {
            this.channel.write((Object)new BinaryWebSocketFrame(this.toOutputBuffer(output)), this.channel.newPromise().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                    if (future.isSuccess()) {
                        onComplete.run();
                    }
                }
            }));
        }
        return this;
    }

    @Override
    public WebSocketTransport writeAndFlush(ProtonBuffer output, final Runnable onComplete) throws IOException {
        this.checkConnected();
        int length = output.getReadableBytes();
        if (length == 0) {
            return this;
        }
        LOG.trace("Attempted write and flush of: {} bytes", (Object)length);
        if (onComplete == null) {
            this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(this.toOutputBuffer(output)), this.channel.voidPromise());
        } else {
            this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(this.toOutputBuffer(output)), this.channel.newPromise().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                    if (future.isSuccess()) {
                        onComplete.run();
                    }
                }
            }));
        }
        return this;
    }

    @Override
    public URI getRemoteURI() {
        if (this.host != null) {
            try {
                return new URI(this.getScheme(), null, this.host, this.port, this.options.webSocketPath(), null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected ChannelInboundHandlerAdapter createChannelHandler() {
        return new NettyWebSocketTransportHandler();
    }

    @Override
    protected void addAdditionalHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
        if (this.options.webSocketCompression()) {
            pipeline.addLast(new ChannelHandler[]{new WebSocketClientCompressionHandler(0)});
        }
    }

    @Override
    protected void handleConnected(Channel channel) throws Exception {
        LOG.trace("Channel has become active, awaiting WebSocket handshake! Channel is {}", (Object)channel);
    }

    @Override
    protected String getScheme() {
        return this.isSecure() ? "wss" : "ws";
    }

    private class NettyWebSocketTransportHandler
    extends TcpTransport.NettyDefaultHandler<Object> {
        private final WebSocketClientHandshaker handshaker;

        public NettyWebSocketTransportHandler() {
            super(WebSocketTransport.this);
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            WebSocketTransport.this.options.webSocketHeaders().forEach((key, value) -> headers.set(key, value));
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)WebSocketTransport.this.getRemoteURI(), (WebSocketVersion)WebSocketVersion.V13, (String)WebSocketTransport.AMQP_SUB_PROTOCOL, (boolean)true, (HttpHeaders)headers, (int)WebSocketTransport.this.options.webSocketMaxFrameSize());
        }

        @Override
        public void channelInactive(ChannelHandlerContext context) throws Exception {
            if (WebSocketTransport.this.handshakeTimeoutFuture != null) {
                WebSocketTransport.this.handshakeTimeoutFuture.cancel(false);
            }
            super.channelInactive(context);
        }

        @Override
        public void channelActive(ChannelHandlerContext context) throws Exception {
            this.handshaker.handshake(context.channel());
            WebSocketTransport.this.handshakeTimeoutFuture = context.executor().schedule(() -> {
                LOG.trace("WebSocket handshake timed out! Channel is {}", (Object)context.channel());
                if (!this.handshaker.isHandshakeComplete()) {
                    WebSocketTransport.super.handleTransportFailure(WebSocketTransport.this.channel, new IOException("WebSocket handshake timed out"));
                }
            }, (long)WebSocketTransport.this.getTransportOptions().connectTimeout(), TimeUnit.MILLISECONDS);
            super.channelActive(context);
        }

        protected void channelRead0(ChannelHandlerContext ctx, Object message) throws Exception {
            LOG.trace("New data read: incoming: {}", message);
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)message);
                LOG.trace("WebSocket Client connected! {}", (Object)ctx.channel());
                if (WebSocketTransport.this.handshakeTimeoutFuture.cancel(false)) {
                    WebSocketTransport.super.handleConnected(ch);
                }
                return;
            }
            if (message instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)message;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + String.valueOf(response.status()) + ", content=" + response.content().toString(StandardCharsets.UTF_8) + ")");
            }
            WebSocketFrame frame = (WebSocketFrame)message;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                LOG.warn("WebSocket Client received message: " + textFrame.text());
                ctx.fireExceptionCaught((Throwable)new IOException("Received invalid frame over WebSocket."));
            } else if (frame instanceof BinaryWebSocketFrame) {
                BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
                LOG.trace("WebSocket Client received data: {} bytes", (Object)binaryFrame.content().readableBytes());
                this.dispatchReadBuffer(binaryFrame.content());
            } else if (frame instanceof ContinuationWebSocketFrame) {
                ContinuationWebSocketFrame continuationFrame = (ContinuationWebSocketFrame)frame;
                LOG.trace("WebSocket Client received data continuation: {} bytes", (Object)continuationFrame.content().readableBytes());
                this.dispatchReadBuffer(continuationFrame.content());
            } else if (frame instanceof PingWebSocketFrame) {
                LOG.trace("WebSocket Client received ping, response with pong");
                ch.write((Object)new PongWebSocketFrame(frame.content()));
            } else if (frame instanceof CloseWebSocketFrame) {
                LOG.trace("WebSocket Client received closing");
                ch.close();
            }
        }
    }
}

