/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec;

import com.rabbitmq.qpid.protonj2.codec.Decoder;
import com.rabbitmq.qpid.protonj2.codec.Encoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.ProtonDecoderFactory;
import com.rabbitmq.qpid.protonj2.codec.encoders.ProtonEncoderFactory;

public final class CodecFactory {
    private static Encoder amqpTypeEncoder;
    private static Encoder saslTypeEncoder;
    private static Decoder amqpTypeDecoder;
    private static Decoder saslTypeDecoder;

    private CodecFactory() {
    }

    public static void setEncoder(Encoder encoder) {
        amqpTypeEncoder = encoder;
    }

    public static void setDecoder(Decoder decoder) {
        amqpTypeDecoder = decoder;
    }

    public static void setSaslEncoder(Encoder encoder) {
        saslTypeEncoder = encoder;
    }

    public static void setSaslDecoder(Decoder decoder) {
        saslTypeDecoder = decoder;
    }

    public static Encoder getEncoder() {
        if (amqpTypeEncoder == null) {
            amqpTypeEncoder = CodecFactory.getDefaultEncoder();
        }
        return amqpTypeEncoder;
    }

    public static Decoder getDecoder() {
        if (amqpTypeDecoder == null) {
            amqpTypeDecoder = CodecFactory.getDefaultDecoder();
        }
        return amqpTypeDecoder;
    }

    public static Encoder getSaslEncoder() {
        if (saslTypeEncoder == null) {
            saslTypeEncoder = CodecFactory.getDefaultSaslEncoder();
        }
        return saslTypeEncoder;
    }

    public static Decoder getSaslDecoder() {
        if (saslTypeDecoder == null) {
            saslTypeDecoder = CodecFactory.getDefaultSaslDecoder();
        }
        return saslTypeDecoder;
    }

    public static Encoder getDefaultEncoder() {
        return ProtonEncoderFactory.create();
    }

    public static Decoder getDefaultDecoder() {
        return ProtonDecoderFactory.create();
    }

    public static Encoder getDefaultSaslEncoder() {
        return ProtonEncoderFactory.createSasl();
    }

    public static Decoder getDefaultSaslDecoder() {
        return ProtonDecoderFactory.createSasl();
    }
}

