/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.primitives;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import java.io.InputStream;

public class BooleanTypeDecoder
extends AbstractPrimitiveTypeDecoder<Boolean> {
    @Override
    public boolean isJavaPrimitive() {
        return true;
    }

    @Override
    public Class<Boolean> getTypeClass() {
        return Boolean.class;
    }

    @Override
    public int getTypeCode() {
        return 86;
    }

    @Override
    public Boolean readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return buffer.readByte() == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public Boolean readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return ProtonStreamUtils.readByte(stream) == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public boolean readPrimitiveValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return buffer.readByte() != 0;
    }

    public boolean readPrimitiveValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return ProtonStreamUtils.readByte(stream) != 0;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.readByte();
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        ProtonStreamUtils.readByte(stream);
    }

    @Override
    public int readSize(ProtonBuffer buffer, DecoderState state) {
        return 1;
    }

    @Override
    public int readSize(InputStream stream, StreamDecoderState state) {
        return 1;
    }
}

