/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.transport.Close;
import com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition;
import java.io.InputStream;

public final class CloseTypeDecoder
extends AbstractDescribedListTypeDecoder<Close> {
    private static final int MIN_CLOSE_LIST_ENTRIES = 0;
    private static final int MAX_CLOSE_LIST_ENTRIES = 1;

    @Override
    public Class<Close> getTypeClass() {
        return Close.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Close.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Close.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Close readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readClose(buffer, state, (ListTypeDecoder)CloseTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Close[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Close[] result = new Close[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readClose(buffer, state, (ListTypeDecoder)CloseTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Close readClose(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Close close = new Close();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Close list encoding: " + count);
        }
        if (count > 1) {
            throw new DecodeException("To many entries in Close list encoding: " + count);
        }
        if (count == 1) {
            close.setError(state.getDecoder().readObject(buffer, state, ErrorCondition.class));
        }
        return close;
    }

    @Override
    public Close readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readClose(stream, state, (ListTypeDecoder)CloseTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Close[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Close[] result = new Close[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readClose(stream, state, (ListTypeDecoder)CloseTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Close readClose(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Close close = new Close();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Close list encoding: " + count);
        }
        if (count > 1) {
            throw new DecodeException("To many entries in Close list encoding: " + count);
        }
        if (count == 1) {
            close.setError(state.getDecoder().readObject(stream, state, ErrorCondition.class));
        }
        return close;
    }
}

