/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.encoders.messaging;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.codec.TypeEncoder;
import com.rabbitmq.qpid.protonj2.codec.encoders.AbstractDescribedTypeEncoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.messaging.AmqpValue;

public final class AmqpValueTypeEncoder
extends AbstractDescribedTypeEncoder<AmqpValue> {
    private static final byte[] VALUE_PREAMBLE = new byte[]{0, 83, AmqpValue.DESCRIPTOR_CODE.byteValue()};

    @Override
    public Class<AmqpValue> getTypeClass() {
        return AmqpValue.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return AmqpValue.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return AmqpValue.DESCRIPTOR_SYMBOL;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, AmqpValue value) {
        buffer.writeBytes(VALUE_PREAMBLE);
        state.getEncoder().writeObject(buffer, state, value.getValue());
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)-16);
        int startIndex = buffer.getWriteOffset();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)0);
        state.getEncoder().writeUnsignedLong(buffer, state, this.getDescriptorCode());
        Object[] elements = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            AmqpValue value = (AmqpValue)values[i];
            elements[i] = value.getValue();
        }
        TypeEncoder<?> entryEncoder = state.getEncoder().getTypeEncoder(elements[0].getClass());
        entryEncoder.writeRawArray(buffer, state, elements);
    }
}

