/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.encoders.messaging;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.Encoder;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.messaging.Properties;

public final class PropertiesTypeEncoder
extends AbstractDescribedListTypeEncoder<Properties> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Properties.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Properties.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Properties> getTypeClass() {
        return Properties.class;
    }

    @Override
    public void writeElement(Properties properties, int index, ProtonBuffer buffer, Encoder encoder, EncoderState state) {
        switch (index) {
            case 0: {
                encoder.writeObject(buffer, state, properties.getMessageId());
                break;
            }
            case 1: {
                encoder.writeBinary(buffer, state, properties.getUserId());
                break;
            }
            case 2: {
                encoder.writeString(buffer, state, properties.getTo());
                break;
            }
            case 3: {
                encoder.writeString(buffer, state, properties.getSubject());
                break;
            }
            case 4: {
                encoder.writeString(buffer, state, properties.getReplyTo());
                break;
            }
            case 5: {
                encoder.writeObject(buffer, state, properties.getCorrelationId());
                break;
            }
            case 6: {
                encoder.writeSymbol(buffer, state, properties.getContentType());
                break;
            }
            case 7: {
                encoder.writeSymbol(buffer, state, properties.getContentEncoding());
                break;
            }
            case 8: {
                if (properties.hasAbsoluteExpiryTime()) {
                    encoder.writeTimestamp(buffer, state, properties.getAbsoluteExpiryTime());
                    break;
                }
                buffer.writeByte((byte)64);
                break;
            }
            case 9: {
                if (properties.hasCreationTime()) {
                    encoder.writeTimestamp(buffer, state, properties.getCreationTime());
                    break;
                }
                buffer.writeByte((byte)64);
                break;
            }
            case 10: {
                encoder.writeString(buffer, state, properties.getGroupId());
                break;
            }
            case 11: {
                if (properties.hasGroupSequence()) {
                    encoder.writeUnsignedInteger(buffer, state, properties.getGroupSequence());
                    break;
                }
                buffer.writeByte((byte)64);
                break;
            }
            case 12: {
                encoder.writeString(buffer, state, properties.getReplyToGroupId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Properties value index: " + index);
            }
        }
    }

    @Override
    public byte getListEncoding(Properties value) {
        return -48;
    }

    @Override
    public int getElementCount(Properties properties) {
        return properties.getElementCount();
    }
}

