/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.encoders.primitives;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;
import com.rabbitmq.qpid.protonj2.types.Binary;

public final class BinaryTypeEncoder
extends AbstractPrimitiveTypeEncoder<Binary> {
    @Override
    public Class<Binary> getTypeClass() {
        return Binary.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Binary value) {
        this.writeType(buffer, state, value.asProtonBuffer());
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, ProtonBuffer value) {
        if (value.getReadableBytes() > 255) {
            buffer.ensureWritable(value.getReadableBytes() + 8);
            buffer.writeByte((byte)-80);
            buffer.writeInt(value.getReadableBytes());
        } else {
            buffer.ensureWritable(value.getReadableBytes() + 2);
            buffer.writeByte((byte)-96);
            buffer.writeByte((byte)value.getReadableBytes());
        }
        value.copyInto(value.getReadOffset(), buffer, buffer.getWriteOffset(), value.getReadableBytes());
        buffer.advanceWriteOffset(value.getReadableBytes());
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, byte[] value) {
        if (value.length > 255) {
            buffer.ensureWritable(value.length + 8);
            buffer.writeByte((byte)-80);
            buffer.writeInt(value.length);
            buffer.writeBytes(value, 0, value.length);
        } else {
            buffer.ensureWritable(value.length + 2);
            buffer.writeByte((byte)-96);
            buffer.writeByte((byte)value.length);
            buffer.writeBytes(value, 0, value.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)-80);
        for (Object value : values) {
            Binary binary = (Binary)value;
            ProtonBuffer binaryBuffer = binary.asProtonBuffer();
            buffer.ensureWritable(binaryBuffer.getReadableBytes() + 4);
            buffer.writeInt(binaryBuffer.getReadableBytes());
            int readOffset = binaryBuffer.getReadOffset();
            try {
                buffer.writeBytes(binaryBuffer);
            }
            finally {
                binaryBuffer.setReadOffset(readOffset);
            }
        }
    }
}

