/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.encoders.primitives;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;

public final class UnsignedIntegerTypeEncoder
extends AbstractPrimitiveTypeEncoder<UnsignedInteger> {
    @Override
    public Class<UnsignedInteger> getTypeClass() {
        return UnsignedInteger.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, UnsignedInteger value) {
        int intValue = value.intValue();
        if (intValue == 0) {
            buffer.writeByte((byte)67);
        } else if (intValue > 0 && intValue <= 255) {
            buffer.writeByte((byte)82);
            buffer.writeByte((byte)intValue);
        } else {
            buffer.writeByte((byte)112);
            buffer.writeInt(intValue);
        }
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, byte value) {
        if (value == 0) {
            buffer.writeByte((byte)67);
        } else {
            buffer.writeByte((byte)82);
            buffer.writeByte(value);
        }
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, int value) {
        if (value == 0) {
            buffer.writeByte((byte)67);
        } else if (value > 0 && value <= 255) {
            buffer.writeByte((byte)82);
            buffer.writeByte((byte)value);
        } else {
            buffer.writeByte((byte)112);
            buffer.writeInt(value);
        }
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, long value) {
        if (value < 0L || value >= 0x100000000L) {
            throw new IllegalArgumentException("Value \"" + value + "\" lies outside the range [0-4294967296).");
        }
        int intValue = (int)value;
        if (intValue == 0) {
            buffer.writeByte((byte)67);
        } else if (intValue > 0 && intValue <= 255) {
            buffer.writeByte((byte)82);
            buffer.writeByte((byte)intValue);
        } else {
            buffer.writeByte((byte)112);
            buffer.writeInt(intValue);
        }
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)112);
        for (Object value : values) {
            buffer.writeInt(((UnsignedInteger)value).intValue());
        }
    }
}

