/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.IncomingAMQPEnvelope;
import com.rabbitmq.qpid.protonj2.engine.OutgoingAMQPEnvelope;
import com.rabbitmq.qpid.protonj2.engine.PerformativeEnvelope;
import com.rabbitmq.qpid.protonj2.engine.util.RingQueue;
import com.rabbitmq.qpid.protonj2.types.transport.Performative;
import java.util.function.Function;
import java.util.function.Supplier;

public class AMQPPerformativeEnvelopePool<E extends PerformativeEnvelope<Performative>> {
    public static final int DEFAULT_MAX_POOL_SIZE = 10;
    private int maxPoolSize = 10;
    private final RingQueue<E> pool = new RingQueue(this.getMaxPoolSize());
    private final Supplier<E> envelopeSupplier;

    public AMQPPerformativeEnvelopePool(Function<AMQPPerformativeEnvelopePool<E>, E> envelopeBuilder) {
        this(envelopeBuilder, 10);
    }

    public AMQPPerformativeEnvelopePool(Function<AMQPPerformativeEnvelopePool<E>, E> envelopeBuilder, int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        this.envelopeSupplier = () -> (PerformativeEnvelope)envelopeBuilder.apply(this);
    }

    public final int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public E take(Performative body, int channel, ProtonBuffer payload) {
        return (E)((PerformativeEnvelope)this.pool.poll(this.envelopeSupplier)).initialize(body, channel, payload);
    }

    void release(E pooledEnvelope) {
        this.pool.offer(pooledEnvelope);
    }

    public static AMQPPerformativeEnvelopePool<IncomingAMQPEnvelope> incomingEnvelopePool(int maxPoolSize) {
        return new AMQPPerformativeEnvelopePool<IncomingAMQPEnvelope>(pool -> new IncomingAMQPEnvelope((AMQPPerformativeEnvelopePool<IncomingAMQPEnvelope>)pool), maxPoolSize);
    }

    public static AMQPPerformativeEnvelopePool<IncomingAMQPEnvelope> incomingEnvelopePool() {
        return new AMQPPerformativeEnvelopePool<IncomingAMQPEnvelope>(pool -> new IncomingAMQPEnvelope((AMQPPerformativeEnvelopePool<IncomingAMQPEnvelope>)pool));
    }

    public static AMQPPerformativeEnvelopePool<OutgoingAMQPEnvelope> outgoingEnvelopePool(int maxPoolSize) {
        return new AMQPPerformativeEnvelopePool<OutgoingAMQPEnvelope>(pool -> new OutgoingAMQPEnvelope((AMQPPerformativeEnvelopePool<OutgoingAMQPEnvelope>)pool), maxPoolSize);
    }

    public static AMQPPerformativeEnvelopePool<OutgoingAMQPEnvelope> outgoingEnvelopePool() {
        return new AMQPPerformativeEnvelopePool<OutgoingAMQPEnvelope>(pool -> new OutgoingAMQPEnvelope((AMQPPerformativeEnvelopePool<OutgoingAMQPEnvelope>)pool));
    }
}

