/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.ConnectionState;
import com.rabbitmq.qpid.protonj2.engine.EventHandler;
import com.rabbitmq.qpid.protonj2.engine.IncomingDelivery;
import com.rabbitmq.qpid.protonj2.engine.Link;
import com.rabbitmq.qpid.protonj2.engine.LinkState;
import com.rabbitmq.qpid.protonj2.engine.Receiver;
import com.rabbitmq.qpid.protonj2.engine.Sender;
import com.rabbitmq.qpid.protonj2.engine.Session;
import com.rabbitmq.qpid.protonj2.engine.SessionState;
import com.rabbitmq.qpid.protonj2.engine.TransactionController;
import com.rabbitmq.qpid.protonj2.engine.TransactionManager;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineFailedException;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineStateException;
import com.rabbitmq.qpid.protonj2.engine.exceptions.ProtocolViolationException;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonConnection;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEndpoint;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngine;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonLink;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonReceiver;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonSender;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonSessionIncomingWindow;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonSessionOutgoingWindow;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonTransactionController;
import com.rabbitmq.qpid.protonj2.engine.util.SplayMap;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.transport.Attach;
import com.rabbitmq.qpid.protonj2.types.transport.Begin;
import com.rabbitmq.qpid.protonj2.types.transport.ConnectionError;
import com.rabbitmq.qpid.protonj2.types.transport.Detach;
import com.rabbitmq.qpid.protonj2.types.transport.Disposition;
import com.rabbitmq.qpid.protonj2.types.transport.End;
import com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition;
import com.rabbitmq.qpid.protonj2.types.transport.Flow;
import com.rabbitmq.qpid.protonj2.types.transport.Role;
import com.rabbitmq.qpid.protonj2.types.transport.SessionError;
import com.rabbitmq.qpid.protonj2.types.transport.Transfer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ProtonSession
extends ProtonEndpoint<Session>
implements Session {
    private final Begin localBegin = new Begin();
    private Begin remoteBegin;
    private int localChannel;
    private final ProtonSessionOutgoingWindow outgoingWindow;
    private final ProtonSessionIncomingWindow incomingWindow;
    private final Map<String, ProtonSender> senderByNameMap = new LinkedHashMap<String, ProtonSender>();
    private final Map<String, ProtonReceiver> receiverByNameMap = new LinkedHashMap<String, ProtonReceiver>();
    private final SplayMap<ProtonLink<?>> localLinks = new SplayMap();
    private final SplayMap<ProtonLink<?>> remoteLinks = new SplayMap();
    private final Flow cachedFlow = new Flow();
    private final ProtonConnection connection;
    private SessionState localState = SessionState.IDLE;
    private SessionState remoteState = SessionState.IDLE;
    private boolean localBeginSent;
    private boolean localEndSent;
    private EventHandler<Sender> remoteSenderOpenEventHandler;
    private EventHandler<Receiver> remoteReceiverOpenEventHandler;
    private EventHandler<TransactionManager> remoteTxnManagerOpenEventHandler;
    private EventHandler<IncomingDelivery> deliveryReadHandler;

    public ProtonSession(ProtonConnection connection, int localChannel) {
        super(connection.getEngine());
        this.connection = connection;
        this.localChannel = localChannel;
        this.outgoingWindow = new ProtonSessionOutgoingWindow(this);
        this.incomingWindow = new ProtonSessionIncomingWindow(this);
    }

    @Override
    ProtonSession self() {
        return this;
    }

    @Override
    public ProtonConnection getConnection() {
        return this.connection;
    }

    @Override
    public ProtonConnection getParent() {
        return this.connection;
    }

    public int getLocalChannel() {
        return this.localChannel;
    }

    public int getRemoteChannel() {
        return this.remoteBegin != null ? this.remoteBegin.getRemoteChannel() : -1;
    }

    @Override
    public SessionState getState() {
        return this.localState;
    }

    @Override
    public SessionState getRemoteState() {
        return this.remoteState;
    }

    @Override
    public ProtonSession open() throws IllegalStateException, EngineStateException {
        if (this.getState() == SessionState.IDLE) {
            this.checkConnectionClosed();
            this.getEngine().checkShutdownOrFailed("Cannot open a session when Engine is shutdown or failed.");
            this.localState = SessionState.ACTIVE;
            this.incomingWindow.configureOutbound(this.localBegin);
            this.outgoingWindow.configureOutbound(this.localBegin);
            try {
                this.trySyncLocalStateWithRemote();
            }
            finally {
                this.fireLocalOpen();
            }
        }
        return this;
    }

    @Override
    public ProtonSession close() throws EngineFailedException {
        if (this.getState() == SessionState.ACTIVE) {
            this.localState = SessionState.CLOSED;
            try {
                this.engine.checkFailed("Session close called but engine is in a failed state.");
                this.trySyncLocalStateWithRemote();
            }
            finally {
                this.allLinks().forEach(link -> link.handleSessionLocallyClosed(this));
                this.fireLocalClose();
            }
        }
        return this;
    }

    @Override
    public boolean isLocallyOpen() {
        return this.getState() == SessionState.ACTIVE;
    }

    @Override
    public boolean isLocallyClosed() {
        return this.getState() == SessionState.CLOSED;
    }

    @Override
    public Session setIncomingCapacity(int incomingCapacity) {
        this.incomingWindow.setIncomingCapacity(incomingCapacity);
        return this;
    }

    @Override
    public int getIncomingCapacity() {
        return this.incomingWindow.getIncomingCapacity();
    }

    @Override
    public int getRemainingIncomingCapacity() {
        return this.incomingWindow.getRemainingIncomingCapacity();
    }

    @Override
    public Session setOutgoingCapacity(int outgoingCapacity) {
        this.outgoingWindow.setOutgoingCapacity(outgoingCapacity);
        return this;
    }

    @Override
    public int getOutgoingCapacity() {
        return this.outgoingWindow.getOutgoingCapacity();
    }

    @Override
    public int getRemainingOutgoingCapacity() {
        return this.outgoingWindow.getRemainingOutgoingCapacity();
    }

    @Override
    public Session setHandleMax(long handleMax) throws IllegalStateException {
        this.checkNotOpened("Cannot set handle max on already opened Session");
        this.localBegin.setHandleMax(handleMax);
        return this;
    }

    @Override
    public long getHandleMax() {
        return this.localBegin.getHandleMax();
    }

    @Override
    public ProtonSession setProperties(Map<Symbol, Object> properties) {
        this.checkNotOpened("Cannot set Properties on already opened Session");
        if (properties != null) {
            this.localBegin.setProperties(new LinkedHashMap<Symbol, Object>(properties));
        } else {
            this.localBegin.setProperties(properties);
        }
        return this;
    }

    @Override
    public Map<Symbol, Object> getProperties() {
        if (this.localBegin.getProperties() != null) {
            return Collections.unmodifiableMap(this.localBegin.getProperties());
        }
        return null;
    }

    @Override
    public ProtonSession setOfferedCapabilities(Symbol ... capabilities) {
        this.checkNotOpened("Cannot set Offered Capabilities on already opened Session");
        if (capabilities != null) {
            this.localBegin.setOfferedCapabilities(Arrays.copyOf(capabilities, capabilities.length));
        } else {
            this.localBegin.setOfferedCapabilities(capabilities);
        }
        return this;
    }

    @Override
    public Symbol[] getOfferedCapabilities() {
        if (this.localBegin.getOfferedCapabilities() != null) {
            return Arrays.copyOf(this.localBegin.getOfferedCapabilities(), this.localBegin.getOfferedCapabilities().length);
        }
        return null;
    }

    @Override
    public ProtonSession setDesiredCapabilities(Symbol ... capabilities) {
        this.checkNotOpened("Cannot set Desired Capabilities on already opened Session");
        if (capabilities != null) {
            this.localBegin.setDesiredCapabilities(Arrays.copyOf(capabilities, capabilities.length));
        } else {
            this.localBegin.setDesiredCapabilities(capabilities);
        }
        return this;
    }

    @Override
    public Symbol[] getDesiredCapabilities() {
        if (this.localBegin.getDesiredCapabilities() != null) {
            return Arrays.copyOf(this.localBegin.getDesiredCapabilities(), this.localBegin.getDesiredCapabilities().length);
        }
        return null;
    }

    @Override
    public Set<Link<?>> links() {
        return Collections.unmodifiableSet(this.allLinks());
    }

    public Set<ProtonSender> senders() {
        LinkedHashSet<ProtonSender> result = this.senderByNameMap.isEmpty() ? Collections.EMPTY_SET : new LinkedHashSet<ProtonSender>(this.senderByNameMap.values());
        return result;
    }

    public Set<ProtonReceiver> receivers() {
        LinkedHashSet<ProtonReceiver> result = this.receiverByNameMap.isEmpty() ? Collections.EMPTY_SET : new LinkedHashSet<ProtonReceiver>(this.receiverByNameMap.values());
        return result;
    }

    @Override
    public boolean isRemotelyOpen() {
        return this.getRemoteState() == SessionState.ACTIVE;
    }

    @Override
    public boolean isRemotelyClosed() {
        return this.getRemoteState() == SessionState.CLOSED;
    }

    @Override
    public Symbol[] getRemoteOfferedCapabilities() {
        if (this.remoteBegin != null && this.remoteBegin.getOfferedCapabilities() != null) {
            return Arrays.copyOf(this.remoteBegin.getOfferedCapabilities(), this.remoteBegin.getOfferedCapabilities().length);
        }
        return null;
    }

    @Override
    public Symbol[] getRemoteDesiredCapabilities() {
        if (this.remoteBegin != null && this.remoteBegin.getDesiredCapabilities() != null) {
            return Arrays.copyOf(this.remoteBegin.getDesiredCapabilities(), this.remoteBegin.getDesiredCapabilities().length);
        }
        return null;
    }

    @Override
    public Map<Symbol, Object> getRemoteProperties() {
        if (this.remoteBegin != null && this.remoteBegin.getProperties() != null) {
            return Collections.unmodifiableMap(this.remoteBegin.getProperties());
        }
        return null;
    }

    @Override
    public ProtonSender sender(String name) {
        this.checkSessionClosed("Cannot create new Sender from closed Session");
        ProtonSender sender = this.senderByNameMap.get(name);
        if (sender == null) {
            sender = new ProtonSender(this, name);
            this.senderByNameMap.put(name, sender);
        }
        return sender;
    }

    @Override
    public ProtonReceiver receiver(String name) {
        this.checkSessionClosed("Cannot create new Receiver from closed Session");
        ProtonReceiver receiver = this.receiverByNameMap.get(name);
        if (receiver == null) {
            receiver = new ProtonReceiver(this, name);
            this.receiverByNameMap.put(name, receiver);
        }
        return receiver;
    }

    @Override
    public TransactionController coordinator(String name) throws IllegalStateException {
        this.checkSessionClosed("Cannot create new TransactionController from closed Session");
        ProtonSender sender = this.senderByNameMap.get(name);
        if (sender == null) {
            sender = new ProtonSender(this, name);
            this.senderByNameMap.put(name, sender);
        }
        return new ProtonTransactionController(sender);
    }

    @Override
    public ProtonSession senderOpenHandler(EventHandler<Sender> remoteSenderOpenEventHandler) {
        this.remoteSenderOpenEventHandler = remoteSenderOpenEventHandler;
        return this;
    }

    EventHandler<Sender> senderOpenEventHandler() {
        return this.remoteSenderOpenEventHandler;
    }

    @Override
    public ProtonSession receiverOpenHandler(EventHandler<Receiver> remoteReceiverOpenEventHandler) {
        this.remoteReceiverOpenEventHandler = remoteReceiverOpenEventHandler;
        return this;
    }

    EventHandler<Receiver> receiverOpenEventHandler() {
        return this.remoteReceiverOpenEventHandler;
    }

    @Override
    public ProtonSession transactionManagerOpenHandler(EventHandler<TransactionManager> remoteTxnManagerOpenEventHandler) {
        this.remoteTxnManagerOpenEventHandler = remoteTxnManagerOpenEventHandler;
        return this;
    }

    EventHandler<TransactionManager> transactionManagerOpenHandler() {
        return this.remoteTxnManagerOpenEventHandler;
    }

    @Override
    public ProtonSession deliveryReadHandler(EventHandler<IncomingDelivery> deliveryReadHandler) {
        this.deliveryReadHandler = deliveryReadHandler;
        return this;
    }

    EventHandler<IncomingDelivery> deliveryReadHandler() {
        return this.deliveryReadHandler;
    }

    void handleConnectionLocallyClosed(ProtonConnection protonConnection) {
        this.allLinks().forEach(link -> link.handleConnectionLocallyClosed(this.connection));
    }

    void handleConnectionRemotelyClosed(ProtonConnection protonConnection) {
        this.allLinks().forEach(link -> link.handleConnectionRemotelyClosed(this.connection));
    }

    void handleEngineShutdown(ProtonEngine protonEngine) {
        try {
            this.fireEngineShutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.allLinks().forEach(link -> link.handleEngineShutdown(protonEngine));
    }

    void remoteBegin(Begin begin, int channel) {
        this.remoteBegin = begin;
        this.localBegin.setRemoteChannel(channel);
        this.remoteState = SessionState.ACTIVE;
        this.incomingWindow.handleBegin(begin);
        this.outgoingWindow.handleBegin(begin);
        if (this.isLocallyOpen()) {
            this.fireRemoteOpen();
        }
    }

    void remoteEnd(End end, int channel) {
        this.allLinks().forEach(link -> link.handleSessionRemotelyClosed(this));
        this.setRemoteCondition(end.getError());
        this.remoteState = SessionState.CLOSED;
        this.fireRemoteClose();
    }

    void remoteAttach(Attach attach, int channel) {
        if (this.validateHandleMaxCompliance(attach)) {
            if (this.remoteLinks.containsKey((int)attach.getHandle())) {
                ((Session)this.setCondition(new ErrorCondition(SessionError.HANDLE_IN_USE, "Attach received with handle that is already in use"))).close();
                return;
            }
            if (!attach.hasInitialDeliveryCount() && attach.getRole() == Role.SENDER) {
                throw new ProtocolViolationException("Sending peer attach had no initial delivery count");
            }
            ProtonLink link = this.findMatchingPendingLinkOpen(attach);
            if (link == null) {
                link = attach.getRole() == Role.RECEIVER ? this.sender(attach.getName()) : this.receiver(attach.getName());
            }
            this.remoteLinks.put((int)attach.getHandle(), link);
            link.remoteAttach(attach);
        }
    }

    void remoteDetach(Detach detach, int channel) {
        ProtonLink<?> link = this.remoteLinks.remove((int)detach.getHandle());
        if (link == null) {
            this.getEngine().engineFailed(new ProtocolViolationException("Received uncorrelated handle on Detach from remote: " + channel));
            return;
        }
        if (link.isLocallyClosed() || link.isLocallyDetached()) {
            if (link.isReceiver()) {
                this.receiverByNameMap.remove(link.getName());
            } else {
                this.senderByNameMap.remove(link.getName());
            }
        }
        link.remoteDetach(detach);
    }

    void remoteFlow(Flow flow, int channel) {
        boolean previousSessionWritable = this.outgoingWindow.isSendable();
        this.incomingWindow.handleFlow(flow);
        this.outgoingWindow.handleFlow(flow);
        if (flow.hasHandle()) {
            ProtonLink<?> link = this.remoteLinks.get((int)flow.getHandle());
            if (link == null) {
                this.getEngine().engineFailed(new ProtocolViolationException("Received uncorrelated handle on Flow from remote: " + channel));
                return;
            }
            link.remoteFlow(flow);
        } else {
            this.handleSessionOnlyFlow(flow, previousSessionWritable);
        }
    }

    private void handleSessionOnlyFlow(Flow flow, boolean previousSessionWritable) {
        if (previousSessionWritable != this.outgoingWindow.isSendable()) {
            for (ProtonSender sender : this.senders()) {
                sender.handleSessionCreditStateUpdate(this.outgoingWindow);
                if (previousSessionWritable != this.outgoingWindow.isSendable()) continue;
                break;
            }
        }
        if (flow.getEcho()) {
            this.writeFlow(null);
        }
    }

    void remoteTransfer(Transfer transfer, ProtonBuffer payload, int channel) {
        ProtonLink<?> link = this.remoteLinks.get((int)transfer.getHandle());
        if (link == null) {
            this.getEngine().engineFailed(new ProtocolViolationException("Received uncorrelated handle on Transfer from remote: " + channel));
        } else if (!link.isRemotelyOpen()) {
            this.getEngine().engineFailed(new ProtocolViolationException("Received Transfer for detached Receiver: " + String.valueOf(link)));
        } else {
            this.incomingWindow.handleTransfer(link, transfer, payload);
        }
    }

    void remoteDisposition(Disposition disposition, int channel) {
        if (disposition.getRole() == Role.RECEIVER) {
            this.outgoingWindow.handleDisposition(disposition);
        } else {
            this.incomingWindow.handleDisposition(disposition);
        }
    }

    ProtonSessionOutgoingWindow getOutgoingWindow() {
        return this.outgoingWindow;
    }

    ProtonSessionIncomingWindow getIncomingWindow() {
        return this.incomingWindow;
    }

    boolean wasLocalBeginSent() {
        return this.localBeginSent;
    }

    boolean wasLocalEndSent() {
        return this.localEndSent;
    }

    void freeLink(ProtonLink<?> linkToFree) {
        this.freeLocalHandle(linkToFree.getHandle());
        if (linkToFree.isRemotelyClosed() || linkToFree.isRemotelyDetached()) {
            if (linkToFree.isReceiver()) {
                this.receiverByNameMap.remove(linkToFree.getName());
            } else {
                this.senderByNameMap.remove(linkToFree.getName());
            }
        }
    }

    void writeFlow(ProtonLink<?> link) {
        this.cachedFlow.reset();
        if (this.remoteBegin != null) {
            this.cachedFlow.setNextIncomingId(this.getIncomingWindow().getNextIncomingId());
        }
        this.cachedFlow.setNextOutgoingId(this.getOutgoingWindow().getNextOutgoingId());
        this.cachedFlow.setIncomingWindow(this.getIncomingWindow().getIncomingWindow());
        this.cachedFlow.setOutgoingWindow(this.getOutgoingWindow().getOutgoingWindow());
        if (link != null) {
            link.decorateOutgoingFlow(this.cachedFlow);
        }
        this.getEngine().fireWrite(this.cachedFlow, this.localChannel);
    }

    private void checkNotOpened(String errorMessage) {
        if (this.localState.ordinal() > SessionState.IDLE.ordinal()) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private void checkConnectionClosed() {
        if (this.connection.getState() == ConnectionState.CLOSED || this.connection.getRemoteState() == ConnectionState.CLOSED) {
            throw new IllegalStateException("Cannot open a Session from a Connection that is already closed");
        }
    }

    private void checkSessionClosed(String errorMessage) {
        if (this.isLocallyClosed() || this.isRemotelyClosed()) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private ProtonLink<?> findMatchingPendingLinkOpen(Attach remoteAttach) {
        for (ProtonLink protonLink : this.senderByNameMap.values()) {
            if (!protonLink.getName().equals(remoteAttach.getName()) || protonLink.getRemoteState() != LinkState.IDLE || protonLink.getRole() == remoteAttach.getRole()) continue;
            return protonLink;
        }
        for (ProtonLink protonLink : this.receiverByNameMap.values()) {
            if (!protonLink.getName().equals(remoteAttach.getName()) || protonLink.getRemoteState() != LinkState.IDLE || protonLink.getRole() == remoteAttach.getRole()) continue;
            return protonLink;
        }
        return null;
    }

    private boolean validateHandleMaxCompliance(Attach remoteAttach) {
        long remoteHandle = remoteAttach.getHandle();
        if (this.localBegin.getHandleMax() < remoteHandle) {
            ErrorCondition condition = new ErrorCondition(ConnectionError.FRAMING_ERROR, "Session handle-max exceeded");
            this.connection.setCondition(condition);
            this.connection.close();
            return false;
        }
        return true;
    }

    void trySyncLocalStateWithRemote() {
        switch (this.getState()) {
            case IDLE: {
                return;
            }
            case ACTIVE: {
                this.checkIfBeginShouldBeSent();
                break;
            }
            case CLOSED: {
                this.checkIfBeginShouldBeSent();
                this.checkIfEndShouldBeSent();
                break;
            }
            default: {
                throw new IllegalStateException("Session is in unknown state and cannot proceed");
            }
        }
    }

    private void checkIfBeginShouldBeSent() {
        if (!this.wasLocalBeginSent() && this.connection.isLocallyOpen() && this.connection.wasLocalOpenSent()) {
            this.fireSessionBegin();
        }
    }

    private void checkIfEndShouldBeSent() {
        if (!this.wasLocalEndSent() && this.connection.isLocallyOpen() && this.connection.wasLocalOpenSent() && !this.engine.isShutdown()) {
            this.fireSessionEnd();
        }
    }

    private void fireSessionBegin() {
        this.connection.getEngine().fireWrite(this.localBegin, this.localChannel);
        this.localBeginSent = true;
        this.allLinks().forEach(link -> link.trySyncLocalStateWithRemote());
    }

    private void fireSessionEnd() {
        this.connection.getEngine().fireWrite(new End().setError(this.getCondition()), this.localChannel);
        this.localEndSent = true;
        this.connection.freeLocalChannel(this.localChannel);
    }

    long findFreeLocalHandle(ProtonLink<?> link) {
        for (long i = 0L; i <= this.localBegin.getHandleMax(); ++i) {
            if (this.localLinks.containsKey((int)i)) continue;
            this.localLinks.put((int)i, link);
            return i;
        }
        throw new IllegalStateException("no local handle available for allocation");
    }

    private Set<ProtonLink<?>> allLinks() {
        if (this.senderByNameMap.isEmpty() && this.receiverByNameMap.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet result = new HashSet(this.senderByNameMap.size());
        result.addAll(this.senderByNameMap.values());
        result.addAll(this.receiverByNameMap.values());
        return result;
    }

    private void freeLocalHandle(long localHandle) {
        if (localHandle > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Specified local handle is out of range: " + localHandle);
        }
        this.localLinks.remove((int)localHandle);
    }
}

