/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl.sasl;

import com.rabbitmq.qpid.protonj2.engine.EngineSaslDriver;
import com.rabbitmq.qpid.protonj2.engine.EngineState;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngine;
import com.rabbitmq.qpid.protonj2.engine.impl.sasl.ProtonSaslClientContext;
import com.rabbitmq.qpid.protonj2.engine.impl.sasl.ProtonSaslContext;
import com.rabbitmq.qpid.protonj2.engine.impl.sasl.ProtonSaslHandler;
import com.rabbitmq.qpid.protonj2.engine.impl.sasl.ProtonSaslServerContext;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome;

final class ProtonEngineSaslDriver
implements EngineSaslDriver {
    public static final int DEFAULT_MAX_SASL_FRAME_SIZE = 4096;
    private static final int MIN_MAX_SASL_FRAME_SIZE = 512;
    private final ProtonSaslHandler handler;
    private final ProtonEngine engine;
    private int maxFrameSize = 4096;
    private ProtonSaslContext context;

    ProtonEngineSaslDriver(ProtonEngine engine, ProtonSaslHandler handler) {
        this.handler = handler;
        this.engine = engine;
    }

    @Override
    public ProtonSaslClientContext client() {
        if (this.context != null && this.context.isServer()) {
            throw new IllegalStateException("Engine SASL Context already operating in server mode");
        }
        if (this.engine.state().ordinal() > EngineState.STARTED.ordinal()) {
            throw new IllegalStateException("Engine is already shutdown or failed, cannot create client context.");
        }
        if (this.context == null) {
            this.context = new ProtonSaslClientContext(this.handler);
            if (this.engine.state() == EngineState.STARTED) {
                this.context.handleContextInitialization(this.engine);
            }
        }
        return (ProtonSaslClientContext)this.context;
    }

    @Override
    public ProtonSaslServerContext server() {
        if (this.context != null && this.context.isClient()) {
            throw new IllegalStateException("Engine SASL Context already operating in client mode");
        }
        if (this.engine.state().ordinal() > EngineState.STARTED.ordinal()) {
            throw new IllegalStateException("Engine is already shutdown or failed, cannot create server context.");
        }
        if (this.context == null) {
            this.context = new ProtonSaslServerContext(this.handler);
            if (this.engine.state() == EngineState.STARTED) {
                this.context.handleContextInitialization(this.engine);
            }
        }
        return (ProtonSaslServerContext)this.context;
    }

    @Override
    public EngineSaslDriver.SaslState getSaslState() {
        return this.context == null ? EngineSaslDriver.SaslState.IDLE : this.context.getSaslState();
    }

    @Override
    public SaslOutcome getSaslOutcome() {
        return this.context == null ? null : this.context.getSaslOutcome();
    }

    @Override
    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public void setMaxFrameSize(int maxFrameSize) {
        if (this.getSaslState() == EngineSaslDriver.SaslState.IDLE) {
            if (maxFrameSize < 512) {
                throw new IllegalArgumentException("Cannot set a max frame size lower than: 512");
            }
        } else {
            throw new IllegalStateException("Cannot configure max SASL frame size after SASL negotiations have started");
        }
        this.maxFrameSize = maxFrameSize;
    }

    void handleEngineStarting(ProtonEngine engine) {
        if (this.context != null) {
            this.context.handleContextInitialization(engine);
        }
    }

    ProtonSaslContext context() {
        return this.context;
    }
}

