/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl.sasl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import com.rabbitmq.qpid.protonj2.engine.EngineHandlerContext;
import com.rabbitmq.qpid.protonj2.engine.EngineSaslDriver;
import com.rabbitmq.qpid.protonj2.engine.HeaderEnvelope;
import com.rabbitmq.qpid.protonj2.engine.SASLEnvelope;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineStateException;
import com.rabbitmq.qpid.protonj2.engine.exceptions.ProtocolViolationException;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngine;
import com.rabbitmq.qpid.protonj2.engine.impl.sasl.ProtonSaslContext;
import com.rabbitmq.qpid.protonj2.engine.impl.sasl.ProtonSaslHandler;
import com.rabbitmq.qpid.protonj2.engine.sasl.MechanismMismatchException;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslClientContext;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslClientListener;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslContext;
import com.rabbitmq.qpid.protonj2.engine.sasl.SaslSystemException;
import com.rabbitmq.qpid.protonj2.engine.util.StringUtils;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.security.SaslChallenge;
import com.rabbitmq.qpid.protonj2.types.security.SaslInit;
import com.rabbitmq.qpid.protonj2.types.security.SaslMechanisms;
import com.rabbitmq.qpid.protonj2.types.security.SaslOutcome;
import com.rabbitmq.qpid.protonj2.types.security.SaslPerformative;
import com.rabbitmq.qpid.protonj2.types.security.SaslResponse;
import com.rabbitmq.qpid.protonj2.types.transport.AMQPHeader;
import java.util.Arrays;
import java.util.Objects;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.SaslException;

final class ProtonSaslClientContext
extends ProtonSaslContext
implements SaslClientContext {
    private SaslClientListener client = new ProtonDefaultSaslClientListener();
    private boolean headerWritten;
    private boolean headerReceived;
    private boolean mechanismsReceived;
    private boolean mechanismChosen;
    private boolean responseRequired;
    private HeaderEnvelope pausedAMQPHeader;
    private final HeaderReadContext headerReadContext = new HeaderReadContext();
    private final HeaderWriteContext headerWriteContext = new HeaderWriteContext();
    private final SaslReadContext saslReadContext = new SaslReadContext();
    private final SaslWriteContext saslWriteContext = new SaslWriteContext();

    public ProtonSaslClientContext(ProtonSaslHandler handler) {
        super(handler);
    }

    @Override
    public SaslContext.Role getRole() {
        return SaslContext.Role.CLIENT;
    }

    @Override
    public SaslClientContext setListener(SaslClientListener listener) {
        Objects.requireNonNull(listener, "Cannot configure a null SaslClientListener");
        this.client = listener;
        return this;
    }

    @Override
    public SaslClientListener getListener() {
        return this.client;
    }

    @Override
    public SaslClientContext sendSASLHeader() throws IllegalStateException, EngineStateException {
        this.saslHandler.engine().pipeline().fireWrite(HeaderEnvelope.SASL_HEADER_ENVELOPE);
        return this;
    }

    @Override
    public SaslClientContext sendChosenMechanism(Symbol mechanism, String hostname, ProtonBuffer initialResponse) throws IllegalStateException, EngineStateException {
        Objects.requireNonNull(mechanism, "Client must choose a mechanism");
        SaslInit saslInit = new SaslInit().setHostname(hostname).setMechanism(mechanism).setInitialResponse(initialResponse);
        this.saslHandler.engine().pipeline().fireWrite(new SASLEnvelope(saslInit));
        return this;
    }

    @Override
    public SaslClientContext sendResponse(ProtonBuffer response) throws IllegalStateException, EngineStateException {
        Objects.requireNonNull(response);
        this.saslHandler.engine().pipeline().fireWrite(new SASLEnvelope(new SaslResponse().setResponse(response)));
        return this;
    }

    @Override
    public SaslClientContext saslFailure(SaslException failure) {
        if (!this.isDone()) {
            this.done(com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome.SASL_PERM);
            this.saslHandler.engine().engineFailed(failure);
        }
        return this;
    }

    @Override
    ProtonSaslClientContext handleContextInitialization(ProtonEngine engine) {
        this.getListener().initialize(this);
        return this;
    }

    @Override
    AMQPHeader.HeaderHandler<EngineHandlerContext> headerReadContext() {
        return this.headerReadContext;
    }

    @Override
    AMQPHeader.HeaderHandler<EngineHandlerContext> headerWriteContext() {
        return this.headerWriteContext;
    }

    @Override
    SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> saslReadContext() {
        return this.saslReadContext;
    }

    @Override
    SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> saslWriteContext() {
        return this.saslWriteContext;
    }

    private static class ProtonDefaultSaslClientListener
    implements SaslClientListener {
        private static final ProtonBuffer EMPTY_BUFFER = ProtonBufferAllocator.defaultAllocator().allocate(0).convertToReadOnly();
        private static final Symbol ANONYMOUS = Symbol.valueOf("ANONYMOUS");

        private ProtonDefaultSaslClientListener() {
        }

        @Override
        public void handleSaslMechanisms(SaslClientContext context, Symbol[] mechanisms) {
            if (mechanisms != null && Arrays.binarySearch(mechanisms, ANONYMOUS) > 0) {
                context.sendChosenMechanism(ANONYMOUS, null, EMPTY_BUFFER);
            } else {
                ProtonSaslContext sasl = (ProtonSaslContext)((Object)context);
                context.saslFailure(new MechanismMismatchException("Proton default SASL handler only supports ANONYMOUS exchanges", StringUtils.toStringArray(mechanisms)));
                sasl.done(com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome.SASL_SYS);
            }
        }

        @Override
        public void handleSaslChallenge(SaslClientContext context, ProtonBuffer challenge) {
            ProtonSaslContext sasl = (ProtonSaslContext)((Object)context);
            context.saslFailure(new SaslSystemException(false, "Proton default SASL handler cannot process challenge steps"));
            sasl.done(com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome.SASL_SYS);
        }

        @Override
        public void handleSaslOutcome(SaslClientContext context, com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome outcome, ProtonBuffer additional) {
        }
    }

    private final class SaslWriteContext
    implements SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> {
        private SaslWriteContext() {
        }

        @Override
        public void handleMechanisms(SaslMechanisms saslMechanisms, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected SASL Mechanisms Frame written from SASL Client.");
        }

        @Override
        public void handleInit(SaslInit saslInit, EngineHandlerContext context) {
            if (ProtonSaslClientContext.this.mechanismChosen) {
                throw new ProtocolViolationException("SASL Init already sent to the remote SASL server");
            }
            ProtonSaslClientContext.this.chosenMechanism = saslInit.getMechanism();
            ProtonSaslClientContext.this.hostname = saslInit.getHostname();
            ProtonSaslClientContext.this.mechanismChosen = true;
            context.fireWrite(new SASLEnvelope(saslInit));
        }

        @Override
        public void handleChallenge(SaslChallenge saslChallenge, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected SASL Challenge Frame written from SASL Client.");
        }

        @Override
        public void handleResponse(SaslResponse saslResponse, EngineHandlerContext context) {
            if (!ProtonSaslClientContext.this.responseRequired) {
                throw new ProtocolViolationException("SASL Response is not currently expected by remote server");
            }
            ProtonSaslClientContext.this.responseRequired = false;
            context.fireWrite(new SASLEnvelope(saslResponse));
        }

        @Override
        public void handleOutcome(SaslOutcome saslOutcome, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected SASL Outcome Frame written from SASL Client.");
        }
    }

    private final class SaslReadContext
    implements SaslPerformative.SaslPerformativeHandler<EngineHandlerContext> {
        private SaslReadContext() {
        }

        @Override
        public void handleMechanisms(SaslMechanisms saslMechanisms, EngineHandlerContext context) {
            if (ProtonSaslClientContext.this.mechanismsReceived) {
                throw new ProtocolViolationException("Remote sent illegal additional SASL Mechanisms frame.");
            }
            ProtonSaslClientContext.this.serverMechanisms = saslMechanisms.getSaslServerMechanisms();
            ProtonSaslClientContext.this.mechanismsReceived = true;
            ProtonSaslClientContext.this.client.handleSaslMechanisms(ProtonSaslClientContext.this, ProtonSaslClientContext.this.getServerMechanisms());
        }

        @Override
        public void handleInit(SaslInit saslInit, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected SASL Init Frame received at SASL Client.");
        }

        @Override
        public void handleChallenge(SaslChallenge saslChallenge, EngineHandlerContext context) {
            if (!ProtonSaslClientContext.this.mechanismsReceived) {
                throw new ProtocolViolationException("Remote sent unexpected SASL Challenge frame.");
            }
            ProtonSaslClientContext.this.responseRequired = true;
            ProtonSaslClientContext.this.client.handleSaslChallenge(ProtonSaslClientContext.this, saslChallenge.getChallenge());
        }

        @Override
        public void handleResponse(SaslResponse saslResponse, EngineHandlerContext context) {
            throw new ProtocolViolationException("Unexpected SASL Response Frame received at SASL Client.");
        }

        @Override
        public void handleOutcome(SaslOutcome saslOutcome, EngineHandlerContext context) {
            SaslException saslFailure;
            block12: {
                ProtonSaslClientContext.this.done(com.rabbitmq.qpid.protonj2.engine.sasl.SaslOutcome.values()[saslOutcome.getCode().ordinal()]);
                saslFailure = null;
                switch (saslOutcome.getCode()) {
                    case AUTH: {
                        saslFailure = new AuthenticationException("SASL exchange failed to authenticate client");
                        break;
                    }
                    case OK: {
                        break;
                    }
                    case SYS: {
                        saslFailure = new SaslSystemException(true, "SASL handshake failed due to a system error");
                        break;
                    }
                    case SYS_TEMP: {
                        saslFailure = new SaslSystemException(false, "SASL handshake failed due to a transient system error");
                        break;
                    }
                    case SYS_PERM: {
                        saslFailure = new SaslSystemException(true, "SASL handshake failed due to a permanent system error");
                        break;
                    }
                    default: {
                        saslFailure = new SaslException("SASL handshake failed due to an unknown error");
                    }
                }
                try {
                    ProtonSaslClientContext.this.client.handleSaslOutcome(ProtonSaslClientContext.this, ProtonSaslClientContext.this.getSaslOutcome(), saslOutcome.getAdditionalData());
                }
                catch (Exception error) {
                    if (saslFailure != null) break block12;
                    saslFailure = new SaslException("Client threw unknown error while processing the outcome", error);
                }
            }
            context.engine().pipeline().remove(ProtonSaslClientContext.this.saslHandler);
            if (saslFailure == null) {
                if (ProtonSaslClientContext.this.pausedAMQPHeader != null) {
                    context.fireWrite(ProtonSaslClientContext.this.pausedAMQPHeader);
                }
            } else {
                context.engine().engineFailed(saslFailure);
            }
        }
    }

    private final class HeaderWriteContext
    implements AMQPHeader.HeaderHandler<EngineHandlerContext> {
        private HeaderWriteContext() {
        }

        @Override
        public void handleAMQPHeader(AMQPHeader header, EngineHandlerContext context) {
            ProtonSaslClientContext.this.pausedAMQPHeader = HeaderEnvelope.AMQP_HEADER_ENVELOPE;
            this.handleSASLHeader(AMQPHeader.getSASLHeader(), context);
        }

        @Override
        public void handleSASLHeader(AMQPHeader header, EngineHandlerContext context) {
            if (ProtonSaslClientContext.this.headerWritten) {
                throw new ProtocolViolationException("SASL Header already sent to the remote SASL server");
            }
            ProtonSaslClientContext.this.headerWritten = true;
            context.fireWrite(HeaderEnvelope.SASL_HEADER_ENVELOPE);
        }
    }

    private final class HeaderReadContext
    implements AMQPHeader.HeaderHandler<EngineHandlerContext> {
        private HeaderReadContext() {
        }

        @Override
        public void handleAMQPHeader(AMQPHeader header, EngineHandlerContext context) {
            ProtonSaslClientContext.this.state = EngineSaslDriver.SaslState.AUTHENTICATION_FAILED;
            context.fireWrite(HeaderEnvelope.SASL_HEADER_ENVELOPE);
            throw new ProtocolViolationException("Remote does not support SASL authentication.");
        }

        @Override
        public void handleSASLHeader(AMQPHeader header, EngineHandlerContext context) {
            if (!ProtonSaslClientContext.this.headerReceived) {
                ProtonSaslClientContext.this.headerReceived = true;
                ProtonSaslClientContext.this.state = EngineSaslDriver.SaslState.AUTHENTICATING;
                if (!ProtonSaslClientContext.this.headerWritten) {
                    context.fireWrite(HeaderEnvelope.SASL_HEADER_ENVELOPE);
                    ProtonSaslClientContext.this.headerWritten = true;
                }
            } else {
                throw new ProtocolViolationException("Remote server sent illegal additional SASL headers.");
            }
        }
    }
}

