/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.sasl.client;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.AbstractMechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.SaslCredentialsProvider;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;

abstract class AbstractScramSHAMechanism
extends AbstractMechanism {
    private static final byte[] INT_1 = new byte[]{0, 0, 0, 1};
    private static final String GS2_HEADER = "n,,";
    private final String clientNonce;
    private final String digestName;
    private final String hmacName;
    private String serverNonce;
    private byte[] salt;
    private int iterationCount;
    private String clientFirstMessageBare;
    private byte[] serverSignature;
    private State state = State.INITIAL;

    AbstractScramSHAMechanism(String digestName, String hmacName, String clientNonce) {
        this.digestName = digestName;
        this.hmacName = hmacName;
        this.clientNonce = clientNonce;
    }

    @Override
    public boolean isApplicable(SaslCredentialsProvider credentials) {
        return credentials.username() != null && !credentials.username().isEmpty() && credentials.password() != null && !credentials.password().isEmpty();
    }

    @Override
    public ProtonBuffer getInitialResponse(SaslCredentialsProvider credentials) throws SaslException {
        if (this.state != State.INITIAL) {
            throw new SaslException("Request for initial response not expected in state " + String.valueOf((Object)this.state));
        }
        StringBuilder buf = new StringBuilder("n=");
        buf.append(this.escapeUsername(this.saslPrep(credentials.username())));
        buf.append(",r=");
        buf.append(this.clientNonce);
        this.clientFirstMessageBare = buf.toString();
        this.state = State.CLIENT_FIRST_SENT;
        byte[] data = (GS2_HEADER + this.clientFirstMessageBare).getBytes(StandardCharsets.US_ASCII);
        return ProtonBufferAllocator.defaultAllocator().copy(data).convertToReadOnly();
    }

    @Override
    public ProtonBuffer getChallengeResponse(SaslCredentialsProvider credentials, ProtonBuffer challenge) throws SaslException {
        byte[] response;
        switch (this.state) {
            case CLIENT_FIRST_SENT: {
                response = this.calculateClientProof(credentials, challenge);
                this.state = State.CLIENT_PROOF_SENT;
                break;
            }
            case CLIENT_PROOF_SENT: {
                this.evaluateOutcome(challenge);
                response = new byte[]{};
                this.state = State.COMPLETE;
                break;
            }
            default: {
                throw new SaslException("No challenge expected in state " + String.valueOf((Object)this.state));
            }
        }
        return ProtonBufferAllocator.defaultAllocator().copy(response).convertToReadOnly();
    }

    @Override
    public void verifyCompletion() throws SaslException {
        super.verifyCompletion();
        if (this.state != State.COMPLETE) {
            throw new SaslException(String.format("SASL exchange was not fully completed. Expected state %s but actual state %s", new Object[]{State.COMPLETE, this.state}));
        }
    }

    private byte[] calculateClientProof(SaslCredentialsProvider credentials, ProtonBuffer challenge) throws SaslException {
        try {
            String serverFirstMessage = challenge.toString(StandardCharsets.US_ASCII);
            String[] parts = serverFirstMessage.split(",");
            if (parts.length < 3) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed");
            }
            if (parts[0].startsWith("m=")) {
                throw new SaslException("Server requires mandatory extension which is not supported: " + parts[0]);
            }
            if (!parts[0].startsWith("r=")) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed, cannot find nonce");
            }
            String nonce = parts[0].substring(2);
            if (!nonce.startsWith(this.clientNonce)) {
                throw new SaslException("Server challenge did not use correct client nonce");
            }
            this.serverNonce = nonce;
            if (!parts[1].startsWith("s=")) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed, cannot find salt");
            }
            String base64Salt = parts[1].substring(2);
            this.salt = Base64.getDecoder().decode(base64Salt);
            if (!parts[2].startsWith("i=")) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed, cannot find iteration count");
            }
            String iterCountString = parts[2].substring(2);
            this.iterationCount = Integer.parseInt(iterCountString);
            if (this.iterationCount <= 0) {
                throw new SaslException("Iteration count " + this.iterationCount + " is not a positive integer");
            }
            byte[] passwordBytes = this.saslPrep(new String(credentials.password())).getBytes(StandardCharsets.UTF_8);
            byte[] saltedPassword = this.generateSaltedPassword(passwordBytes);
            String clientFinalMessageWithoutProof = "c=" + Base64.getEncoder().encodeToString(GS2_HEADER.getBytes(StandardCharsets.US_ASCII)) + ",r=" + this.serverNonce;
            String authMessage = this.clientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessageWithoutProof;
            byte[] clientKey = this.computeHmac(saltedPassword, "Client Key");
            byte[] storedKey = MessageDigest.getInstance(this.digestName).digest(clientKey);
            byte[] clientSignature = this.computeHmac(storedKey, authMessage);
            byte[] clientProof = (byte[])clientKey.clone();
            for (int i = 0; i < clientProof.length; ++i) {
                int n = i;
                clientProof[n] = (byte)(clientProof[n] ^ clientSignature[i]);
            }
            byte[] serverKey = this.computeHmac(saltedPassword, "Server Key");
            this.serverSignature = this.computeHmac(serverKey, authMessage);
            String finalMessageWithProof = clientFinalMessageWithoutProof + ",p=" + Base64.getEncoder().encodeToString(clientProof);
            return finalMessageWithProof.getBytes();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    private void evaluateOutcome(ProtonBuffer challenge) throws SaslException {
        String serverFinalMessage = challenge.toString(StandardCharsets.US_ASCII);
        String[] parts = serverFinalMessage.split(",");
        if (!parts[0].startsWith("v=")) {
            throw new SaslException("Server final message did not contain expected verifier");
        }
        byte[] serverSignature = Base64.getDecoder().decode(parts[0].substring(2));
        if (!MessageDigest.isEqual(this.serverSignature, serverSignature)) {
            throw new SaslException("Server signature did not match expected signature.");
        }
    }

    private byte[] computeHmac(byte[] key, String string) throws SaslException {
        Mac mac = this.createHmac(key);
        mac.update(string.getBytes(StandardCharsets.US_ASCII));
        return mac.doFinal();
    }

    private byte[] generateSaltedPassword(byte[] passwordBytes) throws SaslException {
        Mac mac = this.createHmac(passwordBytes);
        mac.update(this.salt);
        mac.update(INT_1);
        byte[] result = mac.doFinal();
        byte[] previous = null;
        for (int i = 1; i < this.iterationCount; ++i) {
            mac.update(previous != null ? previous : result);
            previous = mac.doFinal();
            for (int x = 0; x < result.length; ++x) {
                int n = x;
                result[n] = (byte)(result[n] ^ previous[x]);
            }
        }
        return result;
    }

    private Mac createHmac(byte[] keyBytes) throws SaslException {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, this.hmacName);
            Mac mac = Mac.getInstance(this.hmacName);
            mac.init(key);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    private String saslPrep(String name) throws SaslException {
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(name)) {
            throw new SaslException("Can only encode names and passwords which are restricted to ASCII characters");
        }
        return name;
    }

    private String escapeUsername(String name) {
        name = name.replace("=", "=3D");
        name = name.replace(",", "=2C");
        return name;
    }

    private static enum State {
        INITIAL,
        CLIENT_FIRST_SENT,
        CLIENT_PROOF_SENT,
        COMPLETE;

    }
}

