/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.logging;

import com.rabbitmq.qpid.protonj2.logging.NoOpProtonLoggerFactory;
import com.rabbitmq.qpid.protonj2.logging.ProtonLogger;
import com.rabbitmq.qpid.protonj2.logging.Slf4JLoggerFactory;

public abstract class ProtonLoggerFactory {
    private static volatile ProtonLoggerFactory loggerFactory;

    public static ProtonLoggerFactory getLoggerFactory() {
        if (loggerFactory == null) {
            loggerFactory = ProtonLoggerFactory.findSupportedLoggingFramework();
        }
        return loggerFactory;
    }

    public static void setLoggerFactory(ProtonLoggerFactory factory) {
        if (loggerFactory == null) {
            throw new IllegalArgumentException("Cannot configure the logger factory as null");
        }
        loggerFactory = factory;
    }

    public static ProtonLogger getLogger(Class<?> clazz) {
        return ProtonLoggerFactory.getLoggerFactory().createLoggerWrapper(clazz.getName());
    }

    public static ProtonLogger getLogger(String name) {
        return ProtonLoggerFactory.getLoggerFactory().createLoggerWrapper(name);
    }

    protected abstract ProtonLogger createLoggerWrapper(String var1);

    private static ProtonLoggerFactory findSupportedLoggingFramework() {
        ProtonLoggerFactory factory = null;
        try {
            factory = Slf4JLoggerFactory.findLoggerFactory();
            factory.createLoggerWrapper(ProtonLoggerFactory.class.getName()).debug("SLF4J found and will be used as the logging framework");
        }
        catch (Throwable t1) {
            factory = NoOpProtonLoggerFactory.INSTANCE;
        }
        return factory;
    }
}

