/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferUtils;
import java.nio.ByteBuffer;

public final class Binary {
    private final ProtonBuffer buffer;
    private int hashCode;

    public Binary() {
        this((ProtonBuffer)null);
    }

    public Binary(ProtonBuffer buffer) {
        this.buffer = buffer != null && !buffer.isReadOnly() ? buffer.copy(true) : buffer;
        if (buffer != null) {
            ProtonBufferUtils.registerCleanup(this, this.buffer);
        }
    }

    public Binary(byte[] data) {
        this(data, 0, data.length);
    }

    public Binary(byte[] data, int offset, int length) {
        this.buffer = ProtonBufferAllocator.defaultAllocator().copy(data, offset, length).convertToReadOnly();
    }

    public Binary copy() {
        if (this.buffer == null) {
            return new Binary();
        }
        return new Binary(this.buffer.copy());
    }

    public byte[] asByteArray() {
        byte[] result = null;
        if (this.buffer != null) {
            result = new byte[this.buffer.getReadableBytes()];
            this.buffer.copyInto(this.buffer.getReadOffset(), result, 0, result.length);
        }
        return result;
    }

    public ByteBuffer asByteBuffer() {
        ByteBuffer result = null;
        if (this.buffer != null) {
            result = ByteBuffer.allocate(this.buffer.getReadableBytes());
            this.buffer.copyInto(this.buffer.getReadOffset(), result, 0, result.remaining());
            result = result.asReadOnlyBuffer();
        }
        return result;
    }

    public ProtonBuffer asProtonBuffer() {
        return this.buffer == null ? null : this.buffer.copy(true);
    }

    public final int hashCode() {
        int hc = this.hashCode;
        if (hc == 0 && this.buffer != null) {
            this.hashCode = this.buffer.hashCode();
        }
        return hc;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binary other = (Binary)o;
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.buffer == null) {
            return other.buffer == null;
        }
        return this.buffer.equals(other.buffer);
    }

    public int getLength() {
        return this.buffer != null ? this.buffer.getReadableBytes() : 0;
    }

    public String toString() {
        if (this.buffer == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.getLength(); ++i) {
            byte c = this.buffer.getByte(i);
            if (c > 31 && c < 127 && c != 92) {
                str.append((char)c);
                continue;
            }
            str.append(String.format("\\x%02x", c));
        }
        return str.toString();
    }
}

