/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types.messaging;

import com.rabbitmq.qpid.protonj2.types.Symbol;
import java.util.HashMap;
import java.util.Map;

public enum TerminusExpiryPolicy {
    LINK_DETACH("link-detach"),
    SESSION_END("session-end"),
    CONNECTION_CLOSE("connection-close"),
    NEVER("never");

    private static final Map<Symbol, TerminusExpiryPolicy> map;
    private final Symbol policy;

    private TerminusExpiryPolicy(String policy) {
        this.policy = Symbol.valueOf(policy);
    }

    public Symbol getPolicy() {
        return this.policy;
    }

    public static TerminusExpiryPolicy valueOf(Symbol policy) {
        TerminusExpiryPolicy expiryPolicy = map.get(policy);
        if (expiryPolicy == null) {
            throw new IllegalArgumentException("Unknown TerminusExpiryPolicy: " + String.valueOf(policy));
        }
        return expiryPolicy;
    }

    static {
        map = new HashMap<Symbol, TerminusExpiryPolicy>();
        map.put(LINK_DETACH.getPolicy(), LINK_DETACH);
        map.put(SESSION_END.getPolicy(), SESSION_END);
        map.put(CONNECTION_CLOSE.getPolicy(), CONNECTION_CLOSE);
        map.put(NEVER.getPolicy(), NEVER);
    }
}

