/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types.security;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.util.StringUtils;
import com.rabbitmq.qpid.protonj2.types.Binary;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.security.SaslCode;
import com.rabbitmq.qpid.protonj2.types.security.SaslPerformative;

public final class SaslOutcome
implements SaslPerformative {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(68L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:sasl-outcome:list");
    private SaslCode code;
    private ProtonBuffer additionalData;

    public SaslCode getCode() {
        return this.code;
    }

    public SaslOutcome setCode(SaslCode code) {
        if (code == null) {
            throw new NullPointerException("the code field is mandatory");
        }
        this.code = code;
        return this;
    }

    public ProtonBuffer getAdditionalData() {
        return this.additionalData;
    }

    public SaslOutcome setAdditionalData(Binary additionalData) {
        this.additionalData = additionalData == null ? null : additionalData.asProtonBuffer();
        return this;
    }

    public SaslOutcome setAdditionalData(ProtonBuffer additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    @Override
    public SaslOutcome copy() {
        SaslOutcome copy = new SaslOutcome();
        if (this.code != null) {
            copy.setCode(this.code);
        }
        copy.setAdditionalData(this.additionalData == null ? null : this.additionalData.copy());
        return copy;
    }

    public String toString() {
        return "SaslOutcome{code=" + String.valueOf((Object)this.code) + ", additionalData=" + (this.additionalData == null ? null : StringUtils.toQuotedString(this.additionalData)) + "}";
    }

    @Override
    public SaslPerformative.SaslPerformativeType getPerformativeType() {
        return SaslPerformative.SaslPerformativeType.OUTCOME;
    }

    @Override
    public <E> void invoke(SaslPerformative.SaslPerformativeHandler<E> handler, E context) {
        handler.handleOutcome(this, context);
    }
}

