/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal;

import com.eclipsesource.restfuse.AuthenticationType;
import com.eclipsesource.restfuse.MediaType;
import com.eclipsesource.restfuse.RequestContext;
import com.eclipsesource.restfuse.annotation.Authentication;
import com.eclipsesource.restfuse.annotation.Header;
import com.eclipsesource.restfuse.annotation.HttpTest;
import com.eclipsesource.restfuse.internal.AuthenticationInfo;
import com.eclipsesource.restfuse.internal.InternalRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;

public class RequestConfiguration {
    private static final String PATH_SEPARATOR = "/";
    private final String baseUrl;
    private final Description description;
    private final Object target;

    public RequestConfiguration(String baseUrl, Description description, Object target) {
        this.baseUrl = baseUrl;
        this.description = description;
        this.target = target;
    }

    public InternalRequest createRequest(RequestContext context) {
        HttpTest call = (HttpTest)this.description.getAnnotation(HttpTest.class);
        String rawPath = this.combineUrlAndPath(this.baseUrl, call.path());
        InternalRequest request = new InternalRequest(this.substituePathSegments(rawPath, context));
        this.addAuthentication(call, request);
        this.addContentType(call, request);
        this.addHeader(call, request, context);
        this.addBody(call, request);
        return request;
    }

    private String substituePathSegments(String path, RequestContext context) {
        String substitutedPath = path;
        Pattern pattern = Pattern.compile(".*?\\{(.*?)\\}.*?");
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            String segment = matcher.group(1);
            this.checkSubstitutionExists(context, segment);
            substitutedPath = substitutedPath.replace("{" + segment + "}", context.getPathSegments().get(segment));
        }
        return substitutedPath;
    }

    private void checkSubstitutionExists(RequestContext context, String segment) {
        if (!context.getPathSegments().containsKey(segment)) {
            throw new IllegalStateException("Misconfigured Destination. Could not replace {" + segment + "}.");
        }
    }

    private void addAuthentication(HttpTest call, InternalRequest request) {
        Authentication[] authentications = call.authentications();
        if (authentications != null) {
            Authentication[] authenticationArray = authentications;
            int n = authentications.length;
            int n2 = 0;
            while (n2 < n) {
                Authentication authentication = authenticationArray[n2];
                AuthenticationType type = authentication.type();
                String user = authentication.user();
                String password = authentication.password();
                request.addAuthenticationInfo(new AuthenticationInfo(type, user, password));
                ++n2;
            }
        }
    }

    private void addContentType(HttpTest call, InternalRequest request) {
        MediaType contentType = call.type();
        if (contentType != null) {
            request.setContentType(contentType.getMimeType());
        }
    }

    private void addHeader(HttpTest call, InternalRequest request, RequestContext context) {
        this.addHeadersFromContext(request, context);
        this.addHeadersFromAnnotation(call, request);
    }

    private void addHeadersFromContext(InternalRequest request, RequestContext context) {
        if (context != null && !context.getHeaders().isEmpty()) {
            Map<String, String> headers = context.getHeaders();
            for (String name : headers.keySet()) {
                request.addHeader(name, headers.get(name));
            }
        }
    }

    private void addHeadersFromAnnotation(HttpTest call, InternalRequest request) {
        Header[] header = call.headers();
        if (header != null) {
            Header[] headerArray = header;
            int n = header.length;
            int n2 = 0;
            while (n2 < n) {
                Header parameter = headerArray[n2];
                request.addHeader(parameter.name(), parameter.value());
                ++n2;
            }
        }
    }

    private void addBody(HttpTest test, InternalRequest request) {
        if (!test.file().equals("")) {
            request.setContent(this.getFileStream(test.file()));
        } else if (!test.content().equals("")) {
            request.setContent(this.getContentStream(test.content()));
        }
    }

    private InputStream getFileStream(String file) {
        URL resource = this.target.getClass().getResource(file);
        try {
            return resource.openStream();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not open file " + file + ". Maybe it's not on the classpath?");
        }
    }

    private InputStream getContentStream(String content) {
        try {
            return new ByteArrayInputStream(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException shouldNotHappen) {
            throw new IllegalStateException(shouldNotHappen);
        }
    }

    private String combineUrlAndPath(String url, String pathValue) {
        String result;
        if (url.endsWith(PATH_SEPARATOR) && pathValue.startsWith(PATH_SEPARATOR)) {
            result = String.valueOf(url) + pathValue.substring(1, pathValue.length());
        } else if (!url.endsWith(PATH_SEPARATOR) && pathValue.startsWith(PATH_SEPARATOR) || url.endsWith(PATH_SEPARATOR) && !pathValue.startsWith(PATH_SEPARATOR)) {
            result = String.valueOf(url) + pathValue;
        } else if (!url.endsWith(PATH_SEPARATOR) && !pathValue.startsWith(PATH_SEPARATOR)) {
            result = String.valueOf(url) + PATH_SEPARATOR + pathValue;
        } else {
            throw new IllegalStateException("Invalid url format with base url " + url + " and path " + pathValue);
        }
        return result;
    }
}

