/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal;

import com.eclipsesource.restfuse.MediaType;
import com.eclipsesource.restfuse.Request;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestImpl
implements Request {
    private Map<String, List<String>> headers;
    private final MediaType contentType;
    private final String body;

    public RequestImpl(String body, MediaType contentType) {
        this.body = body;
        this.contentType = contentType;
        this.headers = new HashMap<String, List<String>>();
    }

    @Override
    public boolean hasBody() {
        return this.body != null;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public MediaType getType() {
        return this.contentType;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        List<String> param = this.headers.get(name);
        if (param == null) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(value);
            this.headers.put(name, params);
        } else {
            param.add(value);
        }
    }
}

