/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal;

import com.eclipsesource.restfuse.MediaType;
import com.eclipsesource.restfuse.Response;
import com.github.kevinsawicki.http.HttpRequest;
import java.util.List;
import java.util.Map;

public class ResponseImpl
implements Response {
    private final String body;
    private final String contentType;
    private final Map<String, List<String>> headers;
    private final int code;
    private final String url;

    public ResponseImpl(HttpRequest request) {
        this.body = request.body();
        this.contentType = request.contentType();
        this.headers = request.headers();
        this.code = request.code();
        this.url = request.getConnection().getURL().toString();
        request.disconnect();
    }

    @Override
    public boolean hasBody() {
        return this.body != null;
    }

    @Override
    public <T> T getBody(Class<T> type) {
        if (type != String.class) {
            throw new IllegalArgumentException("Only String is supported. Not the this method is deprecated, see getBody().");
        }
        return (T)this.body;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public MediaType getType() {
        return MediaType.fromString(this.contentType);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public int getStatus() {
        return this.code;
    }

    @Override
    public String getUrl() {
        return this.url;
    }
}

