/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.ScheduledReporter;
import com.ryantenney.metrics.spring.reporter.AbstractReporterFactoryBean;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;

public abstract class AbstractScheduledReporterFactoryBean<T extends ScheduledReporter>
extends AbstractReporterFactoryBean<T>
implements SmartLifecycle,
DisposableBean {
    private static final Pattern DURATION_STRING_PATTERN = Pattern.compile("^(\\d+)\\s?(ns|us|ms|s|m|h|d)?$");
    private boolean running;

    public void start() {
        if (this.isEnabled() && !this.isRunning()) {
            ((ScheduledReporter)this.getObject()).start(this.getPeriod(), TimeUnit.NANOSECONDS);
            this.running = true;
        }
    }

    public void stop() {
        if (this.isEnabled() && this.isRunning()) {
            ((ScheduledReporter)this.getObject()).stop();
            this.running = true;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void destroy() throws Exception {
        this.stop();
    }

    protected abstract long getPeriod();

    protected long convertDurationString(String duration) {
        Matcher m = DURATION_STRING_PATTERN.matcher(duration);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid duration string format");
        }
        long sourceDuration = Long.parseLong(m.group(1));
        String sourceUnitString = m.group(2);
        TimeUnit sourceUnit = "ns".equalsIgnoreCase(sourceUnitString) ? TimeUnit.NANOSECONDS : ("us".equalsIgnoreCase(sourceUnitString) ? TimeUnit.MICROSECONDS : ("ms".equalsIgnoreCase(sourceUnitString) ? TimeUnit.MILLISECONDS : ("s".equalsIgnoreCase(sourceUnitString) ? TimeUnit.SECONDS : ("m".equalsIgnoreCase(sourceUnitString) ? TimeUnit.MINUTES : ("h".equalsIgnoreCase(sourceUnitString) ? TimeUnit.HOURS : ("d".equalsIgnoreCase(sourceUnitString) ? TimeUnit.DAYS : TimeUnit.MILLISECONDS))))));
        return sourceUnit.toNanos(sourceDuration);
    }

    public int getPhase() {
        return 0;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isAutoStartup() {
        return true;
    }
}

