/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="backwards-compatibility-check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class BackwardsCompatibilityCheckMojo
extends AbstractMojo {
    @Parameter(defaultValue="src/main/proto")
    private String protoSourceRoot;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String exeDirPath = this.mavenProject.getBuild().getDirectory() + "/protolock-bin";
        String exePath = exeDirPath + "/protolock";
        File exeDir = new File(exeDirPath);
        if (!exeDir.exists()) {
            exeDir.mkdir();
            String os = this.mavenProject.getProperties().getProperty("os.detected.name");
            if (os == null) {
                this.getLog().error((CharSequence)"Add os-maven-plugin to your POM. https://github.com/trustin/os-maven-plugin");
                throw new MojoExecutionException("Unable to detect OS type.");
            }
            if (!os.equals("osx") && !os.equals("linux")) {
                throw new MojoExecutionException("OS not supported.");
            }
            try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(os + "/protolock");
                 FileOutputStream out = new FileOutputStream(exePath);){
                File exeFile = new File(exePath);
                this.write(in, out);
                exeFile.setExecutable(true, false);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.toString());
            }
        }
        try {
            File lockFile = new File(this.protoSourceRoot + "/proto.lock");
            if (!lockFile.exists()) {
                Runtime.getRuntime().exec(exePath + " init", null, new File(this.protoSourceRoot)).waitFor();
                this.getLog().info((CharSequence)"Initialized protolock.");
            } else {
                String s;
                Process protolock = Runtime.getRuntime().exec(exePath + " status", null, new File(this.protoSourceRoot));
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(protolock.getInputStream()));
                while ((s = stdInput.readLine()) != null) {
                    this.getLog().error((CharSequence)s);
                }
                if (protolock.waitFor() != 0) {
                    throw new MojoFailureException("Backwards compatibility check failed!");
                }
                Runtime.getRuntime().exec(exePath + " commit", null, new File(this.protoSourceRoot));
                this.getLog().info((CharSequence)"Backwards compatibility check passed.");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException(e.toString());
        }
    }

    private void write(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }
}

