/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="backwards-compatibility-check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class BackwardsCompatibilityCheckMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/src/main/proto")
    private String protoSourceRoot;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path exePath;
        String classifier = this.mavenProject.getProperties().getProperty("os.detected.classifier");
        if (classifier == null) {
            this.getLog().error((CharSequence)"Add os-maven-plugin to your POM. https://github.com/trustin/os-maven-plugin");
            throw new MojoExecutionException("Unable to detect OS type.");
        }
        Path exeDirPath = Paths.get(this.mavenProject.getBuild().getDirectory(), "protolock-bin");
        if (!Files.isDirectory(exeDirPath, new LinkOption[0])) {
            try {
                Files.createDirectory(exeDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create the protolock binary directory", (Exception)e);
            }
        }
        String exeExtension = "";
        if (classifier.startsWith("windows")) {
            exeExtension = ".exe";
        }
        if (!Files.exists(exePath = exeDirPath.resolve("protolock" + exeExtension), new LinkOption[0])) {
            String protolockResourcePath = classifier + "/protolock" + exeExtension;
            try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(protolockResourcePath);){
                if (in == null) {
                    throw new MojoExecutionException("OS not supported. Unable to find a protolock binary for the classifier " + classifier);
                }
                Files.copy(in, exePath, new CopyOption[0]);
                PosixFileAttributeView attributes = Files.getFileAttributeView(exePath, PosixFileAttributeView.class, new LinkOption[0]);
                if (attributes != null) {
                    attributes.setPermissions(PosixFilePermissions.fromString("rwxrwxr-x"));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write the protolock binary", (Exception)e);
            }
        }
        try {
            Path lockFile = Paths.get(this.protoSourceRoot, "proto.lock");
            if (!Files.exists(lockFile, new LinkOption[0])) {
                Runtime.getRuntime().exec(exePath + " init", null, new File(this.protoSourceRoot)).waitFor();
                this.getLog().info((CharSequence)"Initialized protolock.");
            } else {
                String s;
                Process protolock = Runtime.getRuntime().exec(exePath + " status", null, new File(this.protoSourceRoot));
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(protolock.getInputStream()));
                while ((s = stdInput.readLine()) != null) {
                    this.getLog().error((CharSequence)s);
                }
                if (protolock.waitFor() != 0) {
                    throw new MojoFailureException("Backwards compatibility check failed!");
                }
                Runtime.getRuntime().exec(exePath + " commit", null, new File(this.protoSourceRoot));
                this.getLog().info((CharSequence)"Backwards compatibility check passed.");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("An error occurred while running protolock", e);
        }
    }
}

