/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding;

import com.sap.cloud.environment.servicebinding.BindingMetadata;
import com.sap.cloud.environment.servicebinding.BindingProperty;
import com.sap.cloud.environment.servicebinding.BindingPropertyFormat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BindingMetadataFactory {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(BindingMetadataFactory.class);

    private BindingMetadataFactory() {
        throw new AssertionError((Object)"This utility class must not be instantiated");
    }

    @Nonnull
    public static Optional<BindingMetadata> tryFromJsonFile(@Nonnull Path filePath) {
        try {
            return Optional.of(BindingMetadataFactory.getFromJsonFile(filePath));
        }
        catch (Exception e) {
            logger.debug("Unable to create '{}' from '{}': {}.", new Object[]{BindingMetadata.class.getName(), filePath, e.getMessage()});
            return Optional.empty();
        }
    }

    @Nonnull
    public static Optional<BindingMetadata> tryFromJson(@Nonnull String jsonMetadata) {
        try {
            return Optional.of(BindingMetadataFactory.getFromJson(jsonMetadata));
        }
        catch (Exception e) {
            logger.debug("Unable to create '{}' from '{}': {}.", new Object[]{BindingMetadata.class.getName(), jsonMetadata, e.getMessage()});
            return Optional.empty();
        }
    }

    @Nonnull
    public static BindingMetadata getFromJsonFile(@Nonnull Path filePath) {
        try {
            String fileContent = String.join((CharSequence)"\n", Files.readAllLines(filePath));
            return BindingMetadataFactory.getFromJson(fileContent);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to read the file content of '%s'", filePath.getFileName()), e);
        }
    }

    @Nonnull
    public static BindingMetadata getFromJson(@Nonnull String jsonMetadata) {
        try {
            return BindingMetadataFactory.getFromJson(new JSONObject(jsonMetadata));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("The given metadata must be a valid JSON object.", e);
        }
    }

    @Nonnull
    public static BindingMetadata getFromJson(@Nonnull JSONObject jsonMetadata) {
        Collection<BindingProperty> metadataProperties = BindingMetadataFactory.readProperties(jsonMetadata.optJSONArray("metaDataProperties"));
        Collection<BindingProperty> credentialProperties = BindingMetadataFactory.readProperties(jsonMetadata.optJSONArray("credentialProperties"));
        return new BindingMetadata(metadataProperties, credentialProperties);
    }

    @Nonnull
    private static Collection<BindingProperty> readProperties(@Nullable JSONArray jsonProperties) {
        if (jsonProperties == null) {
            return Collections.emptyList();
        }
        ArrayList<BindingProperty> properties = new ArrayList<BindingProperty>(jsonProperties.length());
        for (int i = 0; i < jsonProperties.length(); ++i) {
            JSONObject jsonMetadataProperty = jsonProperties.optJSONObject(i);
            if (jsonMetadataProperty == null) continue;
            String name = BindingMetadataFactory.readNameField(jsonMetadataProperty);
            String sourceName = BindingMetadataFactory.readSourceNameField(jsonMetadataProperty).orElse(name);
            BindingPropertyFormat format = BindingMetadataFactory.readFormatField(jsonMetadataProperty);
            boolean isContainer = BindingMetadataFactory.readContainerField(jsonMetadataProperty);
            if (!BindingMetadataFactory.isValidName(name) || !BindingMetadataFactory.isValidSourceName(sourceName) || !BindingMetadataFactory.isValidFormat(format, isContainer)) continue;
            properties.add(new BindingProperty(name, sourceName, format, isContainer));
        }
        return properties;
    }

    @Nullable
    private static String readNameField(@Nonnull JSONObject jsonProperty) {
        return jsonProperty.optString("name", null);
    }

    @Nullable
    private static BindingPropertyFormat readFormatField(@Nonnull JSONObject jsonProperty) {
        String rawFormat = jsonProperty.optString("format", null);
        if (rawFormat == null) {
            return null;
        }
        return Arrays.stream(BindingPropertyFormat.values()).filter(format -> format.getValue().equalsIgnoreCase(rawFormat)).findFirst().orElse(null);
    }

    @Nonnull
    private static Optional<String> readSourceNameField(@Nonnull JSONObject jsonProperty) {
        return Optional.ofNullable(jsonProperty.optString("sourceName", null));
    }

    private static boolean readContainerField(@Nonnull JSONObject jsonProperty) {
        return jsonProperty.optBoolean("container", false);
    }

    private static boolean isValidName(@Nullable String name) {
        return name != null && !name.isEmpty();
    }

    private static boolean isValidSourceName(@Nullable String sourceName) {
        return BindingMetadataFactory.isValidName(sourceName);
    }

    private static boolean isValidFormat(@Nullable BindingPropertyFormat format, boolean isContainer) {
        if (format == null) {
            return false;
        }
        if (!isContainer) {
            return true;
        }
        return format == BindingPropertyFormat.JSON;
    }
}

