/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding;

import com.sap.cloud.environment.servicebinding.BindingPropertyFormat;
import java.util.Objects;
import javax.annotation.Nonnull;

class BindingProperty {
    @Nonnull
    private final String name;
    @Nonnull
    private final String sourceName;
    @Nonnull
    private final BindingPropertyFormat format;
    private final boolean isContainer;

    @Nonnull
    public static BindingProperty container(@Nonnull String name) {
        return BindingProperty.container(name, name);
    }

    @Nonnull
    public static BindingProperty container(@Nonnull String name, @Nonnull String sourceName) {
        return new BindingProperty(name, sourceName, BindingPropertyFormat.JSON, true);
    }

    @Nonnull
    public static BindingProperty text(@Nonnull String name) {
        return BindingProperty.text(name, name);
    }

    @Nonnull
    public static BindingProperty text(@Nonnull String name, @Nonnull String sourceName) {
        return new BindingProperty(name, sourceName, BindingPropertyFormat.TEXT, false);
    }

    @Nonnull
    public static BindingProperty json(@Nonnull String name) {
        return BindingProperty.json(name, name);
    }

    @Nonnull
    public static BindingProperty json(@Nonnull String name, @Nonnull String sourceName) {
        return new BindingProperty(name, sourceName, BindingPropertyFormat.JSON, false);
    }

    BindingProperty(@Nonnull String name, @Nonnull String sourceName, @Nonnull BindingPropertyFormat format, boolean isContainer) {
        this.name = name;
        this.sourceName = sourceName;
        this.format = format;
        this.isContainer = isContainer;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getSourceName() {
        return this.sourceName;
    }

    @Nonnull
    public BindingPropertyFormat getFormat() {
        return this.format;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BindingProperty)) {
            return false;
        }
        BindingProperty other = (BindingProperty)obj;
        return this.getName().equals(other.getName()) && this.getSourceName().equals(other.getSourceName()) && this.getFormat() == other.getFormat() && this.isContainer() == other.isContainer();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sourceName, this.format, this.isContainer});
    }
}

