/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding;

import com.sap.cloud.environment.servicebinding.DirectoryBasedCache;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

class FileSystemWatcherCache
implements DirectoryBasedCache {
    @Nonnull
    private static final Collection<WatchEvent.Kind<?>> MODIFICATION_EVENTS = Arrays.asList(StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
    @Nonnull
    private final Function<Path, ServiceBinding> serviceBindingLoader;
    @Nonnull
    final Map<Path, ServiceBinding> cachedServiceBindings = new HashMap<Path, ServiceBinding>();
    @Nonnull
    final Map<Path, WatchKey> directoryWatchKeys = new HashMap<Path, WatchKey>();
    @Nonnull
    private final WatchService watchService;

    public FileSystemWatcherCache(@Nonnull Function<Path, ServiceBinding> serviceBindingLoader) {
        this.serviceBindingLoader = serviceBindingLoader;
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to create new instance of '%s'.", WatchService.class.getSimpleName()), e);
        }
    }

    @Override
    @Nonnull
    public synchronized List<ServiceBinding> getServiceBindings(@Nonnull Collection<Path> directories) {
        this.removeOutdatedWatchKeys(directories);
        this.removeOutdatedServiceBindings(directories);
        return directories.stream().peek(this::renewCachedServiceBindingIfNeeded).map(this.cachedServiceBindings::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void removeOutdatedWatchKeys(@Nonnull Collection<Path> directoriesOfInterest) {
        this.directoryWatchKeys.entrySet().removeIf(entry -> {
            if (directoriesOfInterest.contains(entry.getKey())) {
                return false;
            }
            ((WatchKey)entry.getValue()).cancel();
            return true;
        });
    }

    private void removeOutdatedServiceBindings(@Nonnull Collection<Path> directoriesOfInterest) {
        this.cachedServiceBindings.keySet().removeIf(key -> !directoriesOfInterest.contains(key));
    }

    private void renewCachedServiceBindingIfNeeded(@Nonnull Path directory) {
        WatchKey watchKey = this.directoryWatchKeys.get(directory);
        if (watchKey == null) {
            this.watchAndCacheServiceBinding(directory);
            return;
        }
        if (!watchKey.isValid()) {
            throw new IllegalStateException(String.format("%s for directory '%s' is invalid.", WatchKey.class.getSimpleName(), directory));
        }
        if (this.hasBeenModified(watchKey)) {
            this.cacheServiceBinding(directory);
        }
    }

    private void watchAndCacheServiceBinding(@Nonnull Path directory) {
        this.startWatching(directory);
        this.cacheServiceBinding(directory);
    }

    private void cacheServiceBinding(@Nonnull Path directory) {
        this.cachedServiceBindings.remove(directory);
        ServiceBinding serviceBinding = this.serviceBindingLoader.apply(directory);
        if (serviceBinding == null) {
            return;
        }
        this.cachedServiceBindings.put(directory, serviceBinding);
    }

    private void startWatching(@Nonnull Path directory) {
        try {
            WatchKey watchKey = directory.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            this.directoryWatchKeys.put(directory, watchKey);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to watch directory '%s'.", directory), e);
        }
    }

    private boolean hasBeenModified(@Nonnull WatchKey watchKey) {
        List<WatchEvent<?>> events = watchKey.pollEvents();
        watchKey.reset();
        return events.stream().map(WatchEvent::kind).anyMatch(MODIFICATION_EVENTS::contains);
    }
}

