/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.json.JSONArray;

@FunctionalInterface
interface LayeredPropertySetter {
    @Nonnull
    public static final String CREDENTIALS_KEY = "credentials";
    @Nonnull
    public static final LayeredPropertySetter TO_CREDENTIALS = (binding, name, value) -> {
        Map<String, Object> credentials = null;
        if (binding.containsKey(CREDENTIALS_KEY)) {
            Object maybeCredentials = binding.get(CREDENTIALS_KEY);
            if (maybeCredentials instanceof Map) {
                credentials = (Map)maybeCredentials;
            } else {
                throw new IllegalStateException(String.format("The '%s' property must be of type %s.", CREDENTIALS_KEY, Map.class.getSimpleName()));
            }
        }
        if (credentials == null) {
            credentials = new HashMap<String, Object>();
            binding.put(CREDENTIALS_KEY, credentials);
        }
        credentials.put(name, value);
    };
    @Nonnull
    public static final LayeredPropertySetter TO_ROOT = Map::put;

    @Nonnull
    public static LayeredPropertySetter asList(@Nonnull LayeredPropertySetter actualSetter) {
        return (binding, name, value) -> {
            List list;
            if (value instanceof List) {
                list = (List)value;
            } else if (value instanceof String) {
                list = new JSONArray((String)value).toList();
            } else {
                throw new IllegalStateException(String.format("The provided value '%s' cannot be converted to a %s.", value, List.class.getSimpleName()));
            }
            actualSetter.setProperty(binding, name, list);
        };
    }

    public void setProperty(@Nonnull Map<String, Object> var1, @Nonnull String var2, @Nonnull Object var3);
}

