/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding;

import com.sap.cloud.environment.servicebinding.LayeredParsingStrategy;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LayeredSecretKeyParsingStrategy
implements LayeredParsingStrategy {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(LayeredSecretKeyParsingStrategy.class);
    @Nonnull
    private static final String PLAN_KEY = "plan";
    @Nonnull
    private final Charset charset;

    private LayeredSecretKeyParsingStrategy(@Nonnull Charset charset) {
        this.charset = charset;
    }

    @Nonnull
    public static LayeredSecretKeyParsingStrategy newDefault() {
        return new LayeredSecretKeyParsingStrategy(StandardCharsets.UTF_8);
    }

    @Override
    @Nonnull
    public Optional<ServiceBinding> parse(@Nonnull String serviceName, @Nonnull String bindingName, @Nonnull Path bindingPath) throws IOException {
        logger.debug("Trying to read service binding from '{}'.", (Object)bindingPath);
        List propertyFiles = Files.list(bindingPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        if (propertyFiles.isEmpty()) {
            logger.debug("Skipping '{}': The directory is empty.", (Object)bindingPath);
            return Optional.empty();
        }
        HashMap<String, Object> rawServiceBinding = new HashMap<String, Object>();
        boolean credentialsFound = false;
        for (Path propertyFile : propertyFiles) {
            String propertyName = propertyFile.getFileName().toString();
            String fileContent = String.join((CharSequence)"\n", Files.readAllLines(propertyFile, this.charset));
            if (fileContent.isEmpty()) {
                logger.debug("Ignoring empty property file '{}'.", (Object)propertyFile);
                continue;
            }
            try {
                Map parsedCredentials = new JSONObject(fileContent).toMap();
                if (credentialsFound) {
                    logger.debug("Skipping '{}': More than one JSON file found.", (Object)bindingPath);
                    return Optional.empty();
                }
                credentialsFound = true;
                rawServiceBinding.put("credentials", parsedCredentials);
            }
            catch (JSONException e) {
                rawServiceBinding.put(propertyName, fileContent);
            }
        }
        if (!credentialsFound) {
            logger.debug("Skipping '{}': No credentials property found.", (Object)bindingPath);
            return Optional.empty();
        }
        DefaultServiceBinding serviceBinding = DefaultServiceBinding.builder().copy(rawServiceBinding).withName(bindingName).withServiceName(serviceName).withServicePlanKey(PLAN_KEY).withCredentialsKey("credentials").build();
        logger.debug("Successfully read service binding from '{}'.", (Object)bindingPath);
        return Optional.of(serviceBinding);
    }
}

