/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding;

import com.sap.cloud.environment.servicebinding.LayeredParsingStrategy;
import com.sap.cloud.environment.servicebinding.LayeredPropertySetter;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LayeredSecretRootKeyParsingStrategy
implements LayeredParsingStrategy {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(LayeredSecretRootKeyParsingStrategy.class);
    @Nonnull
    private static final String PLAN_KEY = "plan";
    @Nonnull
    private static final String INSTANCE_GUID_KEY = "instance_guid";
    @Nonnull
    private static final String INSTANCE_NAME_KEY = "instance_name";
    @Nonnull
    private static final String LABEL_KEY = "label";
    @Nonnull
    private static final String TAGS_KEY = "tags";
    @Nonnull
    private static final Map<String, LayeredPropertySetter> DEFAULT_PROPERTY_SETTERS;
    @Nonnull
    private static final LayeredPropertySetter DEFAULT_FALLBACK_PROPERTY_SETTER;
    @Nonnull
    private final Charset charset;
    @Nonnull
    private final Map<String, LayeredPropertySetter> propertySetters;
    @Nonnull
    private final LayeredPropertySetter fallbackPropertySetter;

    private LayeredSecretRootKeyParsingStrategy(@Nonnull Charset charset, @Nonnull Map<String, LayeredPropertySetter> propertySetters, @Nonnull LayeredPropertySetter fallbackPropertySetter) {
        this.charset = charset;
        this.propertySetters = propertySetters;
        this.fallbackPropertySetter = fallbackPropertySetter;
    }

    @Nonnull
    public static LayeredSecretRootKeyParsingStrategy newDefault() {
        return new LayeredSecretRootKeyParsingStrategy(StandardCharsets.UTF_8, DEFAULT_PROPERTY_SETTERS, DEFAULT_FALLBACK_PROPERTY_SETTER);
    }

    @Override
    @Nonnull
    public Optional<ServiceBinding> parse(@Nonnull String serviceName, @Nonnull String bindingName, @Nonnull Path bindingPath) throws IOException {
        Map parsedFileContent;
        logger.debug("Trying to read service binding from '{}'.", (Object)bindingPath);
        List propertyFiles = Files.list(bindingPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        if (propertyFiles.isEmpty()) {
            logger.debug("Skipping '{}': The directory is empty.", (Object)bindingPath);
            return Optional.empty();
        }
        if (propertyFiles.size() > 1) {
            logger.debug("Skipping '{}': The directory contains more than 1 file.", (Object)bindingPath);
            return Optional.empty();
        }
        Path propertyFile = (Path)propertyFiles.get(0);
        String fileContent = String.join((CharSequence)"\n", Files.readAllLines(propertyFile, this.charset));
        if (fileContent.isEmpty()) {
            logger.debug("Skipping '{}': The service binding file ('{}') is empty.", (Object)bindingPath, (Object)propertyFile);
            return Optional.empty();
        }
        try {
            parsedFileContent = new JSONObject(fileContent).toMap();
        }
        catch (JSONException e) {
            logger.debug("Skipping '{}': The service binding file ('{}') does not contain valid JSON.", (Object)bindingPath, (Object)propertyFile);
            return Optional.empty();
        }
        if (parsedFileContent == null) {
            logger.debug("Skipping '{}': The service binding file ('{}') does not contain valid JSON.", (Object)bindingPath, (Object)propertyFile);
            return Optional.empty();
        }
        HashMap<String, Object> rawServiceBinding = new HashMap<String, Object>();
        for (Map.Entry property : parsedFileContent.entrySet()) {
            String name = (String)property.getKey();
            Object value = property.getValue();
            if (name == null || value == null) continue;
            this.getPropertySetter(name).setProperty(rawServiceBinding, name, value);
        }
        DefaultServiceBinding serviceBinding = DefaultServiceBinding.builder().copy(rawServiceBinding).withName(bindingName).withServiceName(serviceName).withServicePlanKey(PLAN_KEY).withTagsKey(TAGS_KEY).withCredentialsKey("credentials").build();
        logger.debug("Successfully read service binding from '{}'.", (Object)bindingPath);
        return Optional.of(serviceBinding);
    }

    @Nonnull
    private LayeredPropertySetter getPropertySetter(@Nonnull String propertyName) {
        return this.propertySetters.getOrDefault(propertyName, this.fallbackPropertySetter);
    }

    static {
        DEFAULT_FALLBACK_PROPERTY_SETTER = LayeredPropertySetter.TO_CREDENTIALS;
        HashMap<String, LayeredPropertySetter> defaultPropertySetters = new HashMap<String, LayeredPropertySetter>();
        defaultPropertySetters.put(PLAN_KEY, LayeredPropertySetter.TO_ROOT);
        defaultPropertySetters.put(INSTANCE_GUID_KEY, LayeredPropertySetter.TO_ROOT);
        defaultPropertySetters.put(INSTANCE_NAME_KEY, LayeredPropertySetter.TO_ROOT);
        defaultPropertySetters.put(LABEL_KEY, LayeredPropertySetter.TO_ROOT);
        defaultPropertySetters.put(TAGS_KEY, LayeredPropertySetter.TO_ROOT);
        DEFAULT_PROPERTY_SETTERS = Collections.unmodifiableMap(defaultPropertySetters);
    }
}

