/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding;

import com.sap.cloud.environment.servicebinding.DirectoryBasedCache;
import com.sap.cloud.environment.servicebinding.FileSystemWatcherCache;
import com.sap.cloud.environment.servicebinding.LayeredDataParsingStrategy;
import com.sap.cloud.environment.servicebinding.LayeredParsingStrategy;
import com.sap.cloud.environment.servicebinding.LayeredSecretKeyParsingStrategy;
import com.sap.cloud.environment.servicebinding.LayeredSecretRootKeyParsingStrategy;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.exception.ServiceBindingAccessException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapServiceOperatorLayeredServiceBindingAccessor
implements ServiceBindingAccessor {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(SapServiceOperatorLayeredServiceBindingAccessor.class);
    @Nonnull
    public static final Path DEFAULT_ROOT_PATH = Paths.get("/etc/secrets/sapbtp", new String[0]);
    @Nonnull
    public static final Collection<LayeredParsingStrategy> DEFAULT_PARSING_STRATEGIES = Collections.unmodifiableCollection(Arrays.asList(LayeredSecretRootKeyParsingStrategy.newDefault(), LayeredSecretKeyParsingStrategy.newDefault(), LayeredDataParsingStrategy.newDefault()));
    @Nonnull
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @Nonnull
    private final Path rootPath;
    @Nonnull
    private final Collection<LayeredParsingStrategy> parsingStrategies;
    @Nonnull
    private final DirectoryBasedCache cache;

    public SapServiceOperatorLayeredServiceBindingAccessor() {
        this(DEFAULT_ROOT_PATH, DEFAULT_PARSING_STRATEGIES);
    }

    public SapServiceOperatorLayeredServiceBindingAccessor(@Nonnull Path rootPath, @Nonnull Collection<LayeredParsingStrategy> parsingStrategies) {
        this(rootPath, parsingStrategies, null);
    }

    SapServiceOperatorLayeredServiceBindingAccessor(@Nonnull Path rootPath, @Nonnull Collection<LayeredParsingStrategy> parsingStrategies, @Nullable DirectoryBasedCache cache) {
        this.rootPath = rootPath;
        this.parsingStrategies = parsingStrategies;
        this.cache = cache != null ? cache : new FileSystemWatcherCache(this::parseServiceBinding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public List<ServiceBinding> getServiceBindings() {
        logger.debug("Trying to read service bindings from '{}'.", (Object)this.rootPath);
        if (!Files.exists(this.rootPath, new LinkOption[0]) || !Files.isDirectory(this.rootPath, new LinkOption[0])) {
            logger.debug("Skipping '{}': Directory does not exist.", (Object)this.rootPath);
            return Collections.emptyList();
        }
        try (Stream<Path> servicePaths = Files.list(this.rootPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            List<ServiceBinding> list = this.parseServiceBindings(servicePaths);
            return list;
        }
        catch (IOException | SecurityException e) {
            throw new ServiceBindingAccessException("Unable to access service binding files.", (Throwable)e);
        }
    }

    @Nonnull
    private List<ServiceBinding> parseServiceBindings(@Nonnull Stream<Path> servicePaths) {
        List<Path> serviceBindingRoots = servicePaths.flatMap(servicePath -> {
            try {
                return Files.list(servicePath);
            }
            catch (IOException e) {
                throw new ServiceBindingAccessException(String.format("Unable to access files in '%s'.", servicePath), (Throwable)e);
            }
        }).collect(Collectors.toList());
        return this.cache.getServiceBindings(serviceBindingRoots);
    }

    @Nullable
    private ServiceBinding parseServiceBinding(@Nonnull Path bindingRoot) {
        Path servicePath = bindingRoot.getParent();
        return this.parsingStrategies.stream().map(strategy -> this.applyStrategy((LayeredParsingStrategy)strategy, servicePath, bindingRoot)).filter(Optional::isPresent).findFirst().orElse(Optional.empty()).orElse(null);
    }

    @Nonnull
    private Optional<ServiceBinding> applyStrategy(@Nonnull LayeredParsingStrategy strategy, @Nonnull Path servicePath, @Nonnull Path bindingPath) {
        try {
            return strategy.parse(servicePath.getFileName().toString(), bindingPath.getFileName().toString(), bindingPath);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

