/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding;

import com.sap.cloud.environment.servicebinding.BindingMetadata;
import com.sap.cloud.environment.servicebinding.BindingMetadataFactory;
import com.sap.cloud.environment.servicebinding.BindingProperty;
import com.sap.cloud.environment.servicebinding.DirectoryBasedCache;
import com.sap.cloud.environment.servicebinding.FileSystemWatcherCache;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.exception.ServiceBindingAccessException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapServiceOperatorServiceBindingIoAccessor
implements ServiceBindingAccessor {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(SapServiceOperatorServiceBindingIoAccessor.class);
    @Nonnull
    public static final Function<String, String> DEFAULT_ENVIRONMENT_VARIABLE_READER = System::getenv;
    @Nonnull
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @Nonnull
    private static final String ROOT_DIRECTORY_KEY = "SERVICE_BINDING_ROOT";
    @Nonnull
    private static final String METADATA_FILE = ".metadata";
    @Nonnull
    private static final String SERVICE_NAME_KEY = "type";
    @Nonnull
    private static final String TAGS_KEY = "tags";
    @Nonnull
    private static final String PLAN_KEY = "plan";
    @Nonnull
    private final Function<String, String> environmentVariableReader;
    @Nonnull
    private final Charset charset;
    @Nonnull
    private final DirectoryBasedCache cache;

    public SapServiceOperatorServiceBindingIoAccessor() {
        this(DEFAULT_ENVIRONMENT_VARIABLE_READER, DEFAULT_CHARSET);
    }

    public SapServiceOperatorServiceBindingIoAccessor(@Nonnull Function<String, String> environmentVariableReader, @Nonnull Charset charset) {
        this(environmentVariableReader, charset, null);
    }

    SapServiceOperatorServiceBindingIoAccessor(@Nonnull Function<String, String> environmentVariableReader, @Nonnull Charset charset, @Nullable DirectoryBasedCache cache) {
        this.environmentVariableReader = environmentVariableReader;
        this.charset = charset;
        this.cache = cache != null ? cache : new FileSystemWatcherCache(this::parseServiceBinding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public List<ServiceBinding> getServiceBindings() throws ServiceBindingAccessException {
        Path rootDirectory = this.getRootDirectory();
        if (rootDirectory == null) {
            return Collections.emptyList();
        }
        logger.debug("Reading service bindings from '{}'.", (Object)rootDirectory);
        try (Stream<Path> bindingRoots = Files.list(rootDirectory).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            List<ServiceBinding> list = this.cache.getServiceBindings(bindingRoots.collect(Collectors.toList()));
            return list;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @Nullable
    private Path getRootDirectory() {
        logger.debug("Trying to determine service binding root directory using the '{}' environment variable.", (Object)ROOT_DIRECTORY_KEY);
        String maybeRootDirectory = this.environmentVariableReader.apply(ROOT_DIRECTORY_KEY);
        if (maybeRootDirectory == null || maybeRootDirectory.isEmpty()) {
            logger.debug("Environment variable '{}' is not defined.", (Object)ROOT_DIRECTORY_KEY);
            return null;
        }
        Path rootDirectory = Paths.get(maybeRootDirectory, new String[0]);
        if (!Files.exists(rootDirectory, new LinkOption[0]) || !Files.isDirectory(rootDirectory, new LinkOption[0])) {
            logger.debug("Environment variable '{}' ('{}') does not point to a valid directory.", (Object)ROOT_DIRECTORY_KEY, (Object)maybeRootDirectory);
            return null;
        }
        return rootDirectory;
    }

    @Nullable
    private ServiceBinding parseServiceBinding(@Nonnull Path rootDirectory) {
        logger.debug("Trying to read service binding from '{}'.", (Object)rootDirectory);
        Path metadataFile = rootDirectory.resolve(METADATA_FILE);
        if (!Files.exists(metadataFile, new LinkOption[0]) || !Files.isRegularFile(metadataFile, new LinkOption[0])) {
            logger.debug("Skipping '{}': The directory does not contain a '{}' file.", (Object)rootDirectory, (Object)METADATA_FILE);
            return null;
        }
        Optional<BindingMetadata> maybeBindingMetadata = BindingMetadataFactory.tryFromJsonFile(metadataFile);
        if (!maybeBindingMetadata.isPresent()) {
            logger.debug("Skipping '{}': Unable to parse the '{}' file.", (Object)rootDirectory, (Object)METADATA_FILE);
            return null;
        }
        String bindingName = rootDirectory.getFileName().toString();
        BindingMetadata bindingMetadata = maybeBindingMetadata.get();
        HashMap<String, Object> rawServiceBinding = new HashMap<String, Object>();
        for (BindingProperty metadataProperty : bindingMetadata.getMetadataProperties()) {
            this.addProperty(rawServiceBinding, rootDirectory, metadataProperty);
        }
        Optional<String> maybeServiceName = this.getServiceName(rawServiceBinding);
        if (!maybeServiceName.isPresent()) {
            logger.debug("Skipping '{}': No '{}' property found.", (Object)rootDirectory, (Object)SERVICE_NAME_KEY);
            return null;
        }
        HashMap<String, Object> rawCredentials = new HashMap<String, Object>();
        for (BindingProperty credentialProperty : bindingMetadata.getCredentialProperties()) {
            this.addProperty(rawCredentials, rootDirectory, credentialProperty);
        }
        if (rawCredentials.isEmpty()) {
            logger.debug("Skipping '{}': No credentials property found.", (Object)rootDirectory);
            return null;
        }
        String credentialsKey = this.generateNewKey(rawServiceBinding);
        rawServiceBinding.put(credentialsKey, rawCredentials);
        DefaultServiceBinding serviceBinding = DefaultServiceBinding.builder().copy(rawServiceBinding).withName(bindingName).withServiceName(maybeServiceName.get()).withTagsKey(TAGS_KEY).withServicePlanKey(PLAN_KEY).withCredentialsKey(credentialsKey).build();
        logger.debug("Successfully read service binding from '{}'.", (Object)rootDirectory);
        return serviceBinding;
    }

    private void addProperty(@Nonnull Map<String, Object> properties, @Nonnull Path rootDirectory, @Nonnull BindingProperty property) {
        Optional maybeValue = this.getPropertyFilePath(rootDirectory, property).flatMap(this::readFile);
        if (!maybeValue.isPresent()) {
            return;
        }
        String value = (String)maybeValue.get();
        switch (property.getFormat()) {
            case TEXT: {
                this.addTextProperty(properties, property, value);
                break;
            }
            case JSON: {
                this.addJsonProperty(properties, property, value);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("The format '%s' is currently not supported", new Object[]{property.getFormat()}));
            }
        }
    }

    private void addTextProperty(@Nonnull Map<String, Object> properties, @Nonnull BindingProperty property, @Nonnull String propertyValue) {
        properties.put(property.getName(), propertyValue);
    }

    private void addJsonProperty(@Nonnull Map<String, Object> properties, @Nonnull BindingProperty property, @Nonnull String propertyValue) {
        JSONObject jsonObject;
        String jsonWrapper = String.format("{\"content\": %s}", propertyValue);
        try {
            jsonObject = new JSONObject(jsonWrapper);
        }
        catch (JSONException e) {
            return;
        }
        if (!property.isContainer()) {
            properties.put(property.getName(), this.getJsonProperty(jsonObject, "content"));
            return;
        }
        JSONObject content = jsonObject.optJSONObject("content");
        if (content == null) {
            return;
        }
        for (String key : content.keySet()) {
            properties.put(key, this.getJsonProperty(content, key));
        }
    }

    @Nullable
    private Object getJsonProperty(@Nonnull JSONObject jsonObject, @Nonnull String key) {
        Object property = jsonObject.get(key);
        if (property instanceof JSONObject) {
            return ((JSONObject)property).toMap();
        }
        if (property instanceof JSONArray) {
            return ((JSONArray)property).toList();
        }
        return property;
    }

    @Nonnull
    private Optional<Path> getPropertyFilePath(@Nonnull Path rootDirectory, @Nonnull BindingProperty property) {
        Path propertyFile = rootDirectory.resolve(property.getSourceName());
        if (!Files.exists(propertyFile, new LinkOption[0]) || !Files.isRegularFile(propertyFile, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(propertyFile);
    }

    @Nonnull
    private Optional<String> readFile(@Nonnull Path path) {
        try {
            return Optional.of(String.join((CharSequence)"\n", Files.readAllLines(path, this.charset)));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    @Nonnull
    private Optional<String> getServiceName(@Nonnull Map<String, Object> rawServiceBinding) {
        Object maybeValue = rawServiceBinding.get(SERVICE_NAME_KEY);
        if (!(maybeValue instanceof String)) {
            return Optional.empty();
        }
        return Optional.of((String)maybeValue);
    }

    @Nonnull
    private String generateNewKey(@Nonnull Map<String, Object> map) {
        for (int i = 0; i < 100; ++i) {
            String key = UUID.randomUUID().toString();
            if (map.containsKey(key)) continue;
            return key;
        }
        throw new IllegalStateException("Unable to generate a new random key. This should never happen!");
    }
}

