/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessRequester;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessedAttribute;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLog;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogUtils;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataObject;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataSubject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLoggerAuditLog
implements AuditLog {
    private static final String ENTRY_SEPARATOR = " | ";
    private static final String UNKNOWN_VALUE = "unknown";
    private final Logger logger;

    public DefaultLoggerAuditLog() {
        this.logger = LoggerFactory.getLogger(DefaultLoggerAuditLog.class);
    }

    DefaultLoggerAuditLog(@Nonnull Logger logger) {
        this.logger = logger;
    }

    private void logToLocal(boolean isBeginning, @Nonnull String topic, @Nonnull AccessRequester initiator, @Nullable String message, @Nullable Throwable e) {
        String initiatorMessage = "INITIATOR: [" + Joiner.on((String)", ").join((Object)("User ID: " + (String)initiator.getPrincipalId().getOrElse((Object)UNKNOWN_VALUE)), (Object)("Tenant ID: " + (String)initiator.getTenantId().getOrElse((Object)UNKNOWN_VALUE)), new Object[]{"IP Address: " + (String)initiator.getIpAddress().getOrElse((Object)UNKNOWN_VALUE), "Channel: " + (String)initiator.getChannel().getOrElse((Object)UNKNOWN_VALUE)}) + "]";
        Joiner messageJoiner = Joiner.on((String)ENTRY_SEPARATOR).skipNulls();
        if (e == null) {
            String phase = isBeginning ? "[BEGINNING]" : "[COMPLETED]";
            this.logger.info(messageJoiner.join((Object)topic, (Object)phase, new Object[]{initiatorMessage, message}));
        } else {
            this.logger.error(messageJoiner.join((Object)topic, (Object)"[FAILED]", new Object[]{initiatorMessage, message}), e);
        }
    }

    @Nonnull
    private String auditObjectToLogMessage(@Nonnull AuditedDataObject object) {
        return "OBJECT: [" + Joiner.on((String)", ").join((Object)("Type: " + object.getType()), (Object)("Identifiers: " + object.getAllIdentifiers()), new Object[0]) + "]";
    }

    @Nonnull
    private String auditSubjectToLogMessage(@Nonnull AuditedDataSubject subject) {
        return "SUBJECT: [" + Joiner.on((String)", ").join((Object)("Type: " + subject.getType()), (Object)("Role: " + subject.getRole()), new Object[]{"Identifiers: " + subject.getAllIdentifiers()}) + "]";
    }

    @Nonnull
    private String attributesToLogMessage(@Nullable Iterable<AccessedAttribute> attributes) {
        StringBuilder message = new StringBuilder("ATTRIBUTES: [");
        if (attributes != null) {
            ObjectMapper jsonMapper = new ObjectMapper();
            for (AccessedAttribute attribute : attributes) {
                try {
                    message.append(jsonMapper.writeValueAsString((Object)attribute));
                }
                catch (JsonProcessingException e) {
                    message.append("{").append(attribute).append("}");
                }
            }
        }
        message.append("]");
        return message.toString();
    }

    private void logSecurityEvent(boolean isBeginning, @Nonnull AccessRequester initiator, @Nullable String message, @Nullable Throwable error) {
        this.logToLocal(isBeginning, "[SECURITY]", initiator, message, error);
    }

    private void logConfigChange(boolean isBeginning, @Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        String message = Joiner.on((String)ENTRY_SEPARATOR).join((Object)this.auditObjectToLogMessage(object), (Object)this.attributesToLogMessage(attributesAffected), new Object[0]);
        this.logToLocal(isBeginning, "[CONFIG]", initiator, message, error);
    }

    private void logDataRead(boolean isBeginning, @Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        String message = Joiner.on((String)ENTRY_SEPARATOR).join((Object)this.auditObjectToLogMessage(object), (Object)this.auditSubjectToLogMessage(subject), new Object[]{this.attributesToLogMessage(attributesAffected)});
        this.logToLocal(isBeginning, "[DATA-READ]", initiator, message, error);
    }

    private void logDataWrite(boolean isBeginning, @Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        String message = Joiner.on((String)ENTRY_SEPARATOR).join((Object)this.auditObjectToLogMessage(object), (Object)this.auditSubjectToLogMessage(subject), new Object[]{this.attributesToLogMessage(attributesAffected)});
        this.logToLocal(isBeginning, "[DATA-WRITE]", initiator, message, error);
    }

    @Override
    public void logSecurityEventBeginning(@Nonnull AccessRequester initiator, @Nullable String message) {
        this.logSecurityEvent(true, initiator, message, null);
    }

    @Override
    public void logSecurityEvent(@Nonnull AccessRequester initiator, @Nullable String message, @Nullable Throwable throwable) {
        this.logSecurityEvent(false, initiator, message, throwable);
    }

    @Override
    public void logConfigChangeBeginning(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logConfigChange(true, initiator, object, AuditLogUtils.attributesAsList(attributeAffected, attributesAffected), null);
    }

    @Override
    public void logConfigChange(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logConfigChange(false, initiator, object, AuditLogUtils.attributesAsList(attributeAffected, attributesAffected), error);
    }

    @Override
    public void logDataReadAttempt(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logDataRead(true, initiator, object, subject, AuditLogUtils.attributesAsList(attributeAffected, attributesAffected), null);
    }

    @Override
    public void logDataRead(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logDataRead(false, initiator, object, subject, AuditLogUtils.attributesAsList(attributeAffected, attributesAffected), error);
    }

    @Override
    public void logDataWriteAttempt(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logDataWrite(true, initiator, object, subject, AuditLogUtils.attributesAsList(attributeAffected, attributesAffected), null);
    }

    @Override
    public void logDataWrite(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logDataWrite(false, initiator, object, subject, AuditLogUtils.attributesAsList(attributeAffected, attributesAffected), error);
    }
}

