/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.JsonElement;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenDecoder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class AuthTokenBuilder {
    @Nonnull
    public FluentHelperBuild decodedJwt(@Nonnull DecodedJWT decodedJwt) {
        return () -> new AuthToken(decodedJwt);
    }

    @Nonnull
    public FluentHelperRefreshToken encodedJwt(@Nonnull String encodedJwt) {
        return new FluentHelperRefreshToken(encodedJwt);
    }

    @Nonnull
    public FluentHelperUnsignedJwt unsignedJwt() {
        return new FluentHelperUnsignedJwt();
    }

    public static class FluentHelperUnsignedJwt {
        @Nullable
        private String zid;
        @Nullable
        private String iss;
        @Nullable
        private Collection<String> audiences;

        @Nonnull
        private URI getIssuerUri(@Nonnull String subdomain) throws CloudPlatformException {
            JsonElement url = ScpCfCloudPlatform.getInstanceOrThrow().getXsuaaServiceCredentials().get("url");
            if (url == null || !url.isJsonPrimitive()) {
                throw new CloudPlatformException("Failed to get XSUAA service URI: no 'url' present in service credentials.");
            }
            try {
                URI uri = new URI(url.getAsString());
                return new URI(uri.getScheme(), null, subdomain + uri.getHost().substring(uri.getHost().indexOf(".")), uri.getPort(), uri.getPath(), null, null);
            }
            catch (URISyntaxException e) {
                throw new CloudPlatformException((Throwable)e);
            }
        }

        @Nonnull
        public FluentHelperBuild ofTenant(@Nonnull String tenantId, @Nonnull String subdomain) throws CloudPlatformException {
            String xsAppName = ((ScpCfCloudPlatform)CloudPlatformAccessor.getCloudPlatform()).getXsAppName();
            return this.ofTenant(tenantId, this.getIssuerUri(subdomain), Collections.singletonList(xsAppName));
        }

        @Nonnull
        public FluentHelperBuild ofTenant(@Nonnull String tenantId, @Nonnull URI issuerUri, @Nonnull Collection<String> audiences) {
            this.zid = tenantId;
            this.iss = issuerUri.toString();
            this.audiences = audiences;
            return this.fluentHelperBuild();
        }

        private FluentHelperBuild fluentHelperBuild() {
            return () -> {
                JWTCreator.Builder jwtBuilder = JWT.create();
                if (this.zid != null) {
                    jwtBuilder.withClaim("zid", this.zid);
                }
                if (this.iss != null) {
                    jwtBuilder.withClaim("iss", this.iss);
                }
                if (this.audiences != null) {
                    jwtBuilder.withAudience(this.audiences.toArray(new String[0]));
                }
                String encodedJwt = jwtBuilder.sign(Algorithm.none());
                DecodedJWT decodedJwt = JWT.decode((String)encodedJwt);
                return new AuthToken(decodedJwt);
            };
        }
    }

    public static class FluentHelperRefreshToken
    implements FluentHelperBuild {
        @Nonnull
        private final String encodedJwt;
        @Nullable
        private String refreshToken;

        @Nonnull
        public FluentHelperBuild refreshToken(@Nonnull String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Override
        @Nonnull
        public AuthToken build() {
            return new AuthTokenDecoder().decodeAndValidate(this.encodedJwt, this.refreshToken);
        }

        @Generated
        public FluentHelperRefreshToken(@Nonnull String encodedJwt) {
            if (encodedJwt == null) {
                throw new NullPointerException("encodedJwt is marked non-null but is null");
            }
            this.encodedJwt = encodedJwt;
        }
    }

    public static interface FluentHelperBuild {
        @Nonnull
        public AuthToken build();
    }
}

