/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenDecoder;
import com.sap.cloud.sdk.cloudplatform.security.OAuth2ServiceProvider;
import com.sap.cloud.sdk.cloudplatform.security.OAuth2TokenServiceCache;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthTokenRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthTokenRequest.class);
    private final AuthTokenDecoder decoder;
    private final OAuth2TokenServiceCache tokenServiceCache;

    AuthTokenRequest(@Nullable AuthTokenDecoder decoder, @Nullable OAuth2TokenServiceCache serviceCache) {
        this.tokenServiceCache = serviceCache == null ? OAuth2TokenServiceCache.create() : serviceCache;
        this.decoder = decoder == null ? new AuthTokenDecoder() : decoder;
    }

    AuthTokenRequest() {
        this(null, null);
    }

    @Nonnull
    AuthToken getXsuaaServiceToken() throws TokenRequestFailedException {
        String accessToken = (String)Try.of((CheckedFunction0 & Serializable)() -> OAuth2ServiceProvider.builder().tokenServiceCache(this.tokenServiceCache).build().getXsuaaTokenFlows().clientCredentialsTokenFlow().execute().getAccessToken()).getOrElseThrow(TokenRequestFailedException::new);
        return this.decoder.decodeAndValidate(accessToken, null);
    }
}

