/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthTokenThreadContextListener
implements ThreadContextListener {
    public static final String PROPERTY_AUTH_TOKEN = AuthTokenThreadContextListener.class.getName() + ":authToken";
    @Nullable
    private final AuthToken authToken;

    public AuthTokenThreadContextListener() {
        this.authToken = null;
    }

    public AuthTokenThreadContextListener(@Nonnull AuthToken authToken) {
        this.authToken = authToken;
    }

    public int getPriority() {
        return -6;
    }

    public void afterInitialize(@Nonnull ThreadContext threadContext) {
        if (this.authToken != null) {
            threadContext.setProperty(PROPERTY_AUTH_TOKEN, Property.of((Object)this.authToken));
        } else {
            threadContext.setPropertyIfAbsent(PROPERTY_AUTH_TOKEN, Property.decorateCallable(AuthTokenAccessor::getCurrentToken));
        }
    }
}

