/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.Cacheable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.impl.client.CloseableHttpClient;

@FunctionalInterface
public interface OAuth2TokenServiceCache {
    @Nonnull
    public OAuth2TokenService getTokenService(@Nullable ClientIdentity var1);

    default public void invalidateCache() {
        throw new UnsupportedOperationException("Cache invalidation not possible.");
    }

    @Nonnull
    public static OAuth2TokenServiceCache create() {
        return OAuth2TokenServiceCache.create(new ConcurrentHashMap<ClientIdentity, OAuth2TokenService>());
    }

    @Nonnull
    public static OAuth2TokenServiceCache create(@Nonnull Map<ClientIdentity, OAuth2TokenService> cache) {
        if (cache instanceof ConcurrentHashMap) {
            return new Default((ConcurrentHashMap)cache);
        }
        return new Default(new ConcurrentHashMap<ClientIdentity, OAuth2TokenService>(cache));
    }

    @Nonnull
    public static OAuth2TokenServiceCache single(@Nonnull OAuth2TokenService tokenService) {
        return identity -> tokenService;
    }

    public static final class Default
    implements OAuth2TokenServiceCache {
        @Nonnull
        private final ConcurrentHashMap<ClientIdentity, OAuth2TokenService> cache;

        @Override
        @Nonnull
        public OAuth2TokenService getTokenService(@Nullable ClientIdentity identity) {
            return this.cache.computeIfAbsent(identity, id -> new DefaultOAuth2TokenService(this.getHttpClient((ClientIdentity)id)));
        }

        @Nonnull
        CloseableHttpClient getHttpClient(@Nullable ClientIdentity identity) {
            return HttpClientFactory.create((ClientIdentity)identity);
        }

        @Override
        public void invalidateCache() {
            this.cache.values().stream().filter(Cacheable.class::isInstance).map(Cacheable.class::cast).forEach(Cacheable::clearCache);
            this.cache.clear();
        }

        @Generated
        private Default(@Nonnull ConcurrentHashMap<ClientIdentity, OAuth2TokenService> cache) {
            if (cache == null) {
                throw new NullPointerException("cache is marked non-null but is null");
            }
            this.cache = cache;
        }
    }
}

