/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;
import com.sap.cloud.sdk.cloudplatform.security.Audience;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.principal.LocalScopePrefixExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.LocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAttribute;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.ScpCfPrincipal;
import com.sap.cloud.sdk.cloudplatform.security.principal.StringCollectionPrincipalAttribute;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuth2AuthTokenPrincipalExtractor
implements PrincipalExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2AuthTokenPrincipalExtractor.class);
    private static final String JWT_CLIENT_ID_CLAIM = "client_id";
    private static final String JWT_USER_NAME_CLAIM = "user_name";
    private static final String JWT_USER_ATTRIBUTES = "xs.user.attributes";
    private static final String JWT_GRANT_TYPE_CLAIM = "grant_type";
    private static final String JWT_GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private static final String JWT_AUDIENCE_CLAIM = "aud";
    private final LocalScopePrefixExtractor localScopePrefixExtractor;
    private final Map<String, CheckedFunction1<DecodedJWT, String>> grantTypeToPrincipalIdExtractor = new HashMap<String, CheckedFunction1<DecodedJWT, String>>();

    OAuth2AuthTokenPrincipalExtractor(@Nullable LocalScopePrefixProvider localScopePrefixProvider) {
        this.localScopePrefixExtractor = new LocalScopePrefixExtractor(localScopePrefixProvider);
        this.grantTypeToPrincipalIdExtractor.put("password", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
        this.grantTypeToPrincipalIdExtractor.put(JWT_GRANT_TYPE_CLIENT_CREDENTIALS, (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_CLIENT_ID_CLAIM).asString());
        this.grantTypeToPrincipalIdExtractor.put("authorization_code", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
        this.grantTypeToPrincipalIdExtractor.put("user_token", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
        this.grantTypeToPrincipalIdExtractor.put("urn:ietf:params:oauth:grant-type:saml2-bearer", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
        this.grantTypeToPrincipalIdExtractor.put("urn:ietf:params:oauth:grant-type:jwt-bearer", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
    }

    void setIdExtractorFunction(@Nonnull String grantType, @Nonnull CheckedFunction1<DecodedJWT, String> principalIdExtractor) {
        CheckedFunction1<DecodedJWT, String> previousExtractorFunction = this.grantTypeToPrincipalIdExtractor.put(grantType, principalIdExtractor);
        if (log.isDebugEnabled()) {
            if (previousExtractorFunction != null) {
                log.debug("Replaced the logic for grant type '" + grantType + "' with a new one.");
            } else {
                log.debug("Added initial logic for grant type '" + grantType + "'.");
            }
        }
    }

    @Nonnull
    private Try<String> getPrincipalId(@Nonnull DecodedJWT jwt) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            String principalId;
            String grantType;
            CheckedFunction1<DecodedJWT, String> idSupplier;
            Claim grantTypeClaim = jwt.getClaim(JWT_GRANT_TYPE_CLAIM);
            if (grantTypeClaim.isMissing() || grantTypeClaim.isNull()) {
                throw new PrincipalAccessException("The current JWT does not contain any grant type.");
            }
            if (log.isDebugEnabled()) {
                if (this.grantTypeToPrincipalIdExtractor.isEmpty()) {
                    log.debug("There is no logic registered for any grant type, so no principal will get extracted from the JWT.");
                } else {
                    log.debug("To extract a principal from JWT the following grant types will get handled: {}", this.grantTypeToPrincipalIdExtractor.keySet());
                }
            }
            if ((idSupplier = this.grantTypeToPrincipalIdExtractor.get(grantType = grantTypeClaim.asString())) == null) {
                throw new PrincipalAccessException("There is no reader registered for grant type '" + grantType + "'.");
            }
            try {
                principalId = (String)idSupplier.apply((Object)jwt);
            }
            catch (Throwable t) {
                throw new PrincipalAccessException("Could not read id for grant type " + grantType + " from JWT.", t);
            }
            if (principalId == null) {
                throw new PrincipalAccessException("The principalId for grant type " + grantType + " must not be null.");
            }
            log.debug("Extracted principal '{}' from the current JWT.", (Object)principalId);
            return principalId;
        });
    }

    @Nonnull
    private Try<Map<String, PrincipalAttribute>> getAttributes(@Nonnull Payload jwt) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            Map attributesMap;
            HashMap<String, StringCollectionPrincipalAttribute> attributes = new HashMap<String, StringCollectionPrincipalAttribute>();
            try {
                attributesMap = jwt.getClaim(JWT_USER_ATTRIBUTES).asMap();
            }
            catch (JWTDecodeException e) {
                throw new PrincipalAccessException("Failed to get user attributes.", (Throwable)e);
            }
            if (attributesMap != null) {
                String grantType = jwt.getClaim(JWT_GRANT_TYPE_CLAIM).asString();
                if (JWT_GRANT_TYPE_CLIENT_CREDENTIALS.equals(grantType)) {
                    throw new PrincipalAccessException("Retrieving 'xs.user.attributes' is not supported for grant type client_credentials.");
                }
                for (Map.Entry entry : attributesMap.entrySet()) {
                    if (!(entry.getValue() instanceof Iterable)) {
                        throw new PrincipalAccessException("Failed to get user attributes: value of attribute map entry is not an instance of Iterable.");
                    }
                    Iterable iterable = (Iterable)entry.getValue();
                    ArrayList<String> values = new ArrayList<String>();
                    for (Object value : iterable) {
                        if (!(value instanceof String)) {
                            throw new PrincipalAccessException("Failed to get user attributes: value is not a String.");
                        }
                        values.add((String)value);
                    }
                    String name = (String)entry.getKey();
                    attributes.put(name, new StringCollectionPrincipalAttribute(name, values));
                }
            } else {
                log.debug("Skipping reading of user attributes: cannot find field '{}' in authorization token.", (Object)JWT_USER_ATTRIBUTES);
            }
            return attributes;
        });
    }

    @Nonnull
    private Try<Set<Authorization>> getLocalAuthorizations(@Nonnull Payload jwt) {
        return this.localScopePrefixExtractor.getAuthorizations(jwt);
    }

    private static Try<Set<Audience>> getAudiences(@Nonnull Payload jwt) {
        return Try.of((CheckedFunction0 & Serializable)() -> OAuth2AuthTokenPrincipalExtractor.extractAudiences(jwt));
    }

    @Nonnull
    private static Set<Audience> extractAudiences(@Nonnull Payload jwt) {
        Claim claim = jwt.getClaim(JWT_AUDIENCE_CLAIM);
        List audiences = claim.asList(String.class);
        if (audiences != null) {
            return audiences.stream().map(Audience::new).collect(Collectors.toSet());
        }
        String audience = claim.asString();
        if (audience != null) {
            return Collections.singleton(new Audience(audience));
        }
        throw new IllegalArgumentException("Could not find audiences in the JWT.");
    }

    private static Try<Set<Authorization>> getAllAuthorizations(@Nonnull Payload jwt) {
        return Try.of((CheckedFunction0 & Serializable)() -> ((List)Option.of((Object)jwt.getClaim("scope").asList(String.class)).getOrElseThrow(() -> new IllegalArgumentException("JWT does not contain any scopes."))).stream().map(Authorization::new).collect(Collectors.toSet()));
    }

    @Override
    @Nonnull
    public Try<Principal> tryGetCurrentPrincipal() {
        Try jwtTry = AuthTokenAccessor.tryGetCurrentToken().map(AuthToken::getJwt);
        if (jwtTry.isFailure()) {
            return Try.failure((Throwable)jwtTry.getCause());
        }
        DecodedJWT jwt = (DecodedJWT)jwtTry.get();
        Try<String> principalId = this.getPrincipalId(jwt);
        if (principalId.isFailure()) {
            return Try.failure((Throwable)principalId.getCause());
        }
        Set localAuthorizations = (Set)this.getLocalAuthorizations((Payload)jwt).getOrElse(Collections::emptySet);
        Map attributes = (Map)this.getAttributes((Payload)jwt).getOrElse(Collections::emptyMap);
        Try allAuthorizationsTry = OAuth2AuthTokenPrincipalExtractor.getAllAuthorizations((Payload)jwt).onFailure(cause -> log.error(cause.getMessage(), cause));
        Try audiencesTry = OAuth2AuthTokenPrincipalExtractor.getAudiences((Payload)jwt).onFailure(cause -> log.error(cause.getMessage(), cause));
        return Try.of((CheckedFunction0 & Serializable)() -> new ScpCfPrincipal((String)principalId.get(), localAuthorizations, (Set)allAuthorizationsTry.getOrElse(Collections::emptySet), (Set)audiencesTry.getOrElse(Collections::emptySet), attributes));
    }
}

