/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.security.principal.BasicCredentialsPrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.DefaultPrincipalFacade;
import com.sap.cloud.sdk.cloudplatform.security.principal.LocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.principal.OAuth2AuthTokenPrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.OidcAuthTokenPrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCfPrincipalFacade
extends DefaultPrincipalFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScpCfPrincipalFacade.class);
    private final Collection<PrincipalExtractor> principalExtractors = new ArrayList<PrincipalExtractor>();

    ScpCfPrincipalFacade(@Nonnull PrincipalExtractor principalExtractor, PrincipalExtractor ... additionalPrincipalExtractors) {
        this.principalExtractors.add(() -> super.tryGetCurrentPrincipal());
        this.principalExtractors.add(principalExtractor);
        this.principalExtractors.addAll(Arrays.asList(additionalPrincipalExtractors));
    }

    public ScpCfPrincipalFacade(@Nullable LocalScopePrefixProvider localScopePrefixProvider) {
        this(new OAuth2AuthTokenPrincipalExtractor(localScopePrefixProvider), new OidcAuthTokenPrincipalExtractor(), new BasicCredentialsPrincipalExtractor());
    }

    public ScpCfPrincipalFacade() {
        this(null);
    }

    public void setIdExtractorFunction(@Nonnull String grantType, @Nonnull CheckedFunction1<DecodedJWT, String> principalIdExtractor) {
        this.principalExtractors.stream().filter(extractor -> extractor instanceof OAuth2AuthTokenPrincipalExtractor).map(extractor -> (OAuth2AuthTokenPrincipalExtractor)extractor).forEach(extractor -> extractor.setIdExtractorFunction(grantType, principalIdExtractor));
    }

    @Nonnull
    public Try<Principal> tryGetCurrentPrincipal() {
        ArrayList throwables = new ArrayList();
        return this.principalExtractors.stream().map(PrincipalExtractor::tryGetCurrentPrincipal).filter(principalTry -> principalTry.onFailure(throwables::add).isSuccess()).findFirst().orElseGet(() -> this.createFallbackException(throwables));
    }

    private Try<Principal> createFallbackException(@Nonnull List<? extends Throwable> throwables) {
        PrincipalAccessException resultingException = new PrincipalAccessException("Could not read a principal from neither a given JWT nor a given Basic Authentication header.");
        throwables.forEach(arg_0 -> resultingException.addSuppressed(arg_0));
        return Try.failure((Throwable)resultingException);
    }
}

