/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.datamodel.odata.client.expression;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.annotations.Beta;

/**
 * OData filter expression operand of type Edm.Guid
 */
@Beta
public interface ValueGuid extends Expressions.OperandSingle, FilterableComparisonAbsolute, FilterableComparisonRelative
{
    /**
     * Null value for guid operations.
     */
    @Nonnull
    ValueGuid NULL = Expressions.OperandSingle.NULL::getExpression;

    @Nonnull
    static ValueGuid literal( @Nonnull final UUID v )
    {
        return ( protocol, prefixes ) -> protocol.getUUIDSerializer().apply(v);
    }
}
