/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.sap.cloud.sdk.datamodel.odatav4.generator.JavadocUtils;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ServiceDetails;
import com.sap.cloud.sdk.result.ElementName;
import io.vavr.control.Option;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

abstract class AbstractServiceDetails
implements ServiceDetails {
    @ElementName(value="info")
    private Info info;
    @ElementName(value="externalDocs")
    private ExternalDocs externalDocs;
    @ElementName(value="x-sap-software-min-version")
    private String minErpVersion;
    @ElementName(value="x-sap-ext-overview")
    private List<ExternalOverview> extOverview;
    @ElementName(value="x-sap-api-deprecated")
    private String deprecated;
    @ElementName(value="x-sap-stateInfo")
    private StateInfo stateInfo;

    public Option<ServiceDetails.StateInfo> getStateInfo() {
        return Option.of((Object)this.stateInfo);
    }

    @Override
    public boolean isDeprecated() {
        return (Boolean)this.getStateInfo().map(info -> ServiceDetails.State.Deprecated == info.getState()).getOrElse((Object)false);
    }

    @Generated
    public AbstractServiceDetails() {
    }

    @Override
    @Generated
    public Info getInfo() {
        return this.info;
    }

    @Override
    @Generated
    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    @Override
    @Generated
    public String getMinErpVersion() {
        return this.minErpVersion;
    }

    @Generated
    public List<ExternalOverview> getExtOverview() {
        return this.extOverview;
    }

    @Generated
    public void setInfo(Info info) {
        this.info = info;
    }

    @Generated
    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    @Generated
    public void setMinErpVersion(String minErpVersion) {
        this.minErpVersion = minErpVersion;
    }

    @Generated
    public void setExtOverview(List<ExternalOverview> extOverview) {
        this.extOverview = extOverview;
    }

    @Generated
    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    @Generated
    public void setStateInfo(StateInfo stateInfo) {
        this.stateInfo = stateInfo;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractServiceDetails)) {
            return false;
        }
        AbstractServiceDetails other = (AbstractServiceDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Info this$info = this.getInfo();
        Info other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        ExternalDocs this$externalDocs = this.getExternalDocs();
        ExternalDocs other$externalDocs = other.getExternalDocs();
        if (this$externalDocs == null ? other$externalDocs != null : !((Object)this$externalDocs).equals(other$externalDocs)) {
            return false;
        }
        String this$minErpVersion = this.getMinErpVersion();
        String other$minErpVersion = other.getMinErpVersion();
        if (this$minErpVersion == null ? other$minErpVersion != null : !this$minErpVersion.equals(other$minErpVersion)) {
            return false;
        }
        List<ExternalOverview> this$extOverview = this.getExtOverview();
        List<ExternalOverview> other$extOverview = other.getExtOverview();
        if (this$extOverview == null ? other$extOverview != null : !((Object)this$extOverview).equals(other$extOverview)) {
            return false;
        }
        String this$deprecated = this.deprecated;
        String other$deprecated = other.deprecated;
        if (this$deprecated == null ? other$deprecated != null : !this$deprecated.equals(other$deprecated)) {
            return false;
        }
        Option<ServiceDetails.StateInfo> this$stateInfo = this.getStateInfo();
        Option<ServiceDetails.StateInfo> other$stateInfo = other.getStateInfo();
        return !(this$stateInfo == null ? other$stateInfo != null : !this$stateInfo.equals(other$stateInfo));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AbstractServiceDetails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Info $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        ExternalDocs $externalDocs = this.getExternalDocs();
        result = result * 59 + ($externalDocs == null ? 43 : ((Object)$externalDocs).hashCode());
        String $minErpVersion = this.getMinErpVersion();
        result = result * 59 + ($minErpVersion == null ? 43 : $minErpVersion.hashCode());
        List<ExternalOverview> $extOverview = this.getExtOverview();
        result = result * 59 + ($extOverview == null ? 43 : ((Object)$extOverview).hashCode());
        String $deprecated = this.deprecated;
        result = result * 59 + ($deprecated == null ? 43 : $deprecated.hashCode());
        Option<ServiceDetails.StateInfo> $stateInfo = this.getStateInfo();
        result = result * 59 + ($stateInfo == null ? 43 : $stateInfo.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "AbstractServiceDetails(info=" + this.getInfo() + ", externalDocs=" + this.getExternalDocs() + ", minErpVersion=" + this.getMinErpVersion() + ", extOverview=" + this.getExtOverview() + ", deprecated=" + this.deprecated + ", stateInfo=" + this.getStateInfo() + ")";
    }

    private static class StateInfo
    implements ServiceDetails.StateInfo {
        @ElementName(value="state")
        private ServiceDetails.State state;
        @ElementName(value="deprecationrelease")
        private String deprecationRelease;
        @ElementName(value="successorApi")
        private String successorApi;
        @ElementName(value="deprecationdate")
        private String deprecationDate;

        @Generated
        public StateInfo() {
        }

        @Override
        @Generated
        public ServiceDetails.State getState() {
            return this.state;
        }

        @Override
        @Generated
        public String getDeprecationRelease() {
            return this.deprecationRelease;
        }

        @Override
        @Generated
        public String getSuccessorApi() {
            return this.successorApi;
        }

        @Override
        @Generated
        public String getDeprecationDate() {
            return this.deprecationDate;
        }

        @Generated
        public void setState(ServiceDetails.State state) {
            this.state = state;
        }

        @Generated
        public void setDeprecationRelease(String deprecationRelease) {
            this.deprecationRelease = deprecationRelease;
        }

        @Generated
        public void setSuccessorApi(String successorApi) {
            this.successorApi = successorApi;
        }

        @Generated
        public void setDeprecationDate(String deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StateInfo)) {
                return false;
            }
            StateInfo other = (StateInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ServiceDetails.State this$state = this.getState();
            ServiceDetails.State other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
                return false;
            }
            String this$deprecationRelease = this.getDeprecationRelease();
            String other$deprecationRelease = other.getDeprecationRelease();
            if (this$deprecationRelease == null ? other$deprecationRelease != null : !this$deprecationRelease.equals(other$deprecationRelease)) {
                return false;
            }
            String this$successorApi = this.getSuccessorApi();
            String other$successorApi = other.getSuccessorApi();
            if (this$successorApi == null ? other$successorApi != null : !this$successorApi.equals(other$successorApi)) {
                return false;
            }
            String this$deprecationDate = this.getDeprecationDate();
            String other$deprecationDate = other.getDeprecationDate();
            return !(this$deprecationDate == null ? other$deprecationDate != null : !this$deprecationDate.equals(other$deprecationDate));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof StateInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ServiceDetails.State $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            String $deprecationRelease = this.getDeprecationRelease();
            result = result * 59 + ($deprecationRelease == null ? 43 : $deprecationRelease.hashCode());
            String $successorApi = this.getSuccessorApi();
            result = result * 59 + ($successorApi == null ? 43 : $successorApi.hashCode());
            String $deprecationDate = this.getDeprecationDate();
            result = result * 59 + ($deprecationDate == null ? 43 : $deprecationDate.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "AbstractServiceDetails.StateInfo(state=" + (Object)((Object)this.getState()) + ", deprecationRelease=" + this.getDeprecationRelease() + ", successorApi=" + this.getSuccessorApi() + ", deprecationDate=" + this.getDeprecationDate() + ")";
        }
    }

    private static class Info
    implements ServiceDetails.Info {
        @ElementName(value="title")
        private String title;
        @ElementName(value="description")
        @JsonAdapter(value=DescriptionAdapter.class)
        private String description;
        @ElementName(value="version")
        private String version;

        @Generated
        public Info() {
        }

        @Override
        @Generated
        public String getTitle() {
            return this.title;
        }

        @Override
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Override
        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Info)) {
                return false;
            }
            Info other = (Info)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Info;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "AbstractServiceDetails.Info(title=" + this.getTitle() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ")";
        }
    }

    private static class ExternalDocs
    implements ServiceDetails.ExternalDocs {
        @ElementName(value="description")
        private String description;
        @ElementName(value="url")
        @JsonAdapter(value=UrlAdapter.class)
        private String url;

        @Generated
        public ExternalDocs() {
        }

        @Override
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Override
        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExternalDocs)) {
                return false;
            }
            ExternalDocs other = (ExternalDocs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ExternalDocs;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "AbstractServiceDetails.ExternalDocs(description=" + this.getDescription() + ", url=" + this.getUrl() + ")";
        }
    }

    private static class ExtOverviewAdapter
    extends TypeAdapter<List<String>> {
        private static final String REGEX_PATTERN = "^\\[(.*)\\]\\((.*) \"(.*)\"\\)$";

        private ExtOverviewAdapter() {
        }

        public void write(@Nonnull JsonWriter out, @Nullable List<String> entityValues) throws IOException {
        }

        public List<String> read(@Nonnull JsonReader in) throws IOException {
            LinkedList<String> result = new LinkedList<String>();
            in.beginArray();
            while (in.hasNext()) {
                if (in.peek() == JsonToken.STRING) {
                    result.add(in.nextString());
                    continue;
                }
                String format = null;
                String text = null;
                in.beginObject();
                while (in.peek() != JsonToken.END_OBJECT) {
                    String propertyName = in.nextName();
                    String propertyValue = in.nextString();
                    if (propertyName.equals("format")) {
                        format = propertyValue;
                        continue;
                    }
                    if (!propertyName.equals("text")) continue;
                    text = propertyValue;
                }
                in.endObject();
                if ("markdown".equals(format) && text != null) {
                    String description = JavadocUtils.formatDescriptionText(text.replaceAll(REGEX_PATTERN, "$1"));
                    String url = text.replaceAll(REGEX_PATTERN, "$2");
                    result.add(String.format("<a href='%s'>%s</a>", url, description));
                    continue;
                }
                result.add(text);
            }
            in.endArray();
            return result;
        }
    }

    private static class UrlAdapter
    extends TypeAdapter<String> {
        private UrlAdapter() {
        }

        public void write(@Nonnull JsonWriter out, @Nullable String value) throws IOException {
        }

        public String read(@Nonnull JsonReader jsonReader) throws IOException {
            String result = jsonReader.nextString();
            return result.trim();
        }
    }

    private static class DescriptionAdapter
    extends TypeAdapter<String> {
        private DescriptionAdapter() {
        }

        public void write(@Nonnull JsonWriter out, @Nullable String value) throws IOException {
        }

        public String read(@Nonnull JsonReader jsonReader) throws IOException {
            String result = jsonReader.nextString();
            return JavadocUtils.formatDescriptionText(result);
        }
    }

    private static class ExternalOverview
    implements ServiceDetails.ExternalOverview {
        @ElementName(value="name")
        private String name;
        @ElementName(value="values")
        @JsonAdapter(value=ExtOverviewAdapter.class)
        private List<String> values;

        @Generated
        public ExternalOverview() {
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public List<String> getValues() {
            return this.values;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setValues(List<String> values) {
            this.values = values;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExternalOverview)) {
                return false;
            }
            ExternalOverview other = (ExternalOverview)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$values = this.getValues();
            List<String> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ExternalOverview;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "AbstractServiceDetails.ExternalOverview(name=" + this.getName() + ", values=" + this.getValues() + ")";
        }
    }
}

