/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.utility.NameSource;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingStrategy;
import com.sap.cloud.sdk.datamodel.odatav4.generator.DataModelGeneratorConfig;
import com.sap.cloud.sdk.datamodel.odatav4.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataToVdmGenerator;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.AnnotationStrategy;
import java.io.File;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;

@Beta
public class DataModelGenerator
implements DataModelGeneratorConfig {
    private static final Logger logger = MessageCollector.getLogger(DataModelGenerator.class);
    public static final String DEFAULT_INPUT_DIRECTORY_NAME = "input";
    public static final String DEFAULT_OUTPUT_DIRECTORY_NAME = "target";
    public static final Boolean DEFAULT_DELETE_OUTPUT_DIRECTORY = false;
    public static final Boolean DEFAULT_OVERWRITE_FILES = false;
    public static final boolean DEFAULT_KEEP_EXISTING_SIGNATURES = true;
    public static final String DEFAULT_PACKAGE_NAME = "com.sap.cloud.sdk.s4hana.datamodel.odatav4";
    public static final String DEFAULT_BASE_PATH = null;
    public static final String DEFAULT_SERVICE_NAME_MAPPING_FILE_NAME = "serviceNameMappings.properties";
    public static final String DEFAULT_NAMING_STRATEGY = "com.sap.cloud.sdk.datamodel.odata.utility.S4HanaNamingStrategy";
    public static final String DEFAULT_ANNOTATION_STRATEGY = "com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.DefaultAnnotationStrategy";
    public static final NameSource DEFAULT_NAMING_SOURCE = NameSource.LABEL;
    public static final Boolean DEFAULT_POJOS_ONLY = false;
    public static final String DEFAULT_EXCLUDES_PATTERN = "";
    public static final Boolean DEFAULT_LINK_TO_API_BUSINESS_HUB = false;
    public static final Boolean DEFAULT_FAIL_ON_WARNING = false;
    public static final Boolean DEFAULT_VERSION_REFERENCE = true;
    public static final String DEFAULT_COPYRIGHT_HEADER = "";
    public static final Boolean DEFAULT_SERVICE_METHODS_PER_ENTITY_SET = false;
    public static final String SAP_COPYRIGHT_HEADER = "/*\n * Copyright (c) 2023 SAP SE or an SAP affiliate company. All rights reserved.\n */\n";
    private File inputDirectory = new File("input");
    private File outputDirectory = new File("target");
    private boolean deleteTargetDirectory = DEFAULT_DELETE_OUTPUT_DIRECTORY;
    private boolean forceFileOverride = DEFAULT_OVERWRITE_FILES;
    private boolean keepExistingSignatures = true;
    private String packageName = "com.sap.cloud.sdk.s4hana.datamodel.odatav4";
    private String defaultBasePath = DEFAULT_BASE_PATH;
    private File serviceNameMappings = new File("serviceNameMappings.properties");
    private NamingStrategy namingStrategy = this.getStrategyInstanceFromName("com.sap.cloud.sdk.datamodel.odata.utility.S4HanaNamingStrategy", NamingStrategy.class);
    private NameSource nameSource = DEFAULT_NAMING_SOURCE;
    private AnnotationStrategy annotationStrategy = this.getStrategyInstanceFromName("com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.DefaultAnnotationStrategy", AnnotationStrategy.class);
    private boolean generatePojosOnly = DEFAULT_POJOS_ONLY;
    private String excludeFilePattern = "";
    private boolean generateLinksToApiBusinessHub = DEFAULT_LINK_TO_API_BUSINESS_HUB;
    private boolean generateVersionReference = DEFAULT_VERSION_REFERENCE;
    private String copyrightHeader = "";
    private Set<String> includedEntitySets = null;
    private Set<String> includedFunctionImports = null;
    private Set<String> includedActionImports = null;
    private boolean serviceMethodsPerEntitySet = DEFAULT_SERVICE_METHODS_PER_ENTITY_SET;
    private String deprecationNotice = null;
    private boolean failOnWarning = DEFAULT_FAIL_ON_WARNING;

    @Nonnull
    public DataModelGenerator withInputDirectory(@Nonnull String inputDirectory) {
        return this.withInputDirectory(new File(inputDirectory));
    }

    @Nonnull
    public DataModelGenerator withInputDirectory(@Nonnull File inputDirectory) {
        this.inputDirectory = inputDirectory;
        return this;
    }

    @Nonnull
    public DataModelGenerator withOutputDirectory(@Nonnull String outputDirectory) {
        return this.withOutputDirectory(new File(outputDirectory));
    }

    @Nonnull
    public DataModelGenerator withOutputDirectory(@Nonnull File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    @Nonnull
    public DataModelGenerator deleteOutputDirectory() {
        return this.deleteOutputDirectory(true);
    }

    @Nonnull
    public DataModelGenerator deleteOutputDirectory(boolean deleteOutputDirectory) {
        this.deleteTargetDirectory = deleteOutputDirectory;
        return this;
    }

    @Nonnull
    public DataModelGenerator overwriteFiles() {
        return this.overwriteFiles(true);
    }

    @Nonnull
    public DataModelGenerator overwriteFiles(boolean overwriteFiles) {
        this.forceFileOverride = overwriteFiles;
        return this;
    }

    @Nonnull
    public DataModelGenerator keepExistingSignatures(boolean keepExistingSignatures) {
        this.keepExistingSignatures = keepExistingSignatures;
        return this;
    }

    @Nonnull
    public DataModelGenerator withPackageName(@Nonnull String packageName) {
        this.packageName = packageName;
        return this;
    }

    @Nonnull
    public DataModelGenerator withDefaultBasePath(@Nullable String defaultBasePath) {
        this.defaultBasePath = defaultBasePath;
        return this;
    }

    @Nonnull
    public DataModelGenerator withServiceNameMapping(@Nonnull File serviceNameMappingFile) {
        this.serviceNameMappings = serviceNameMappingFile;
        return this;
    }

    @Nonnull
    public DataModelGenerator withServiceNameMapping(@Nonnull String serviceNameMappingFile) {
        return this.withServiceNameMapping(new File(serviceNameMappingFile));
    }

    @Nonnull
    public DataModelGenerator withNamingStrategy(@Nonnull NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    @Nonnull
    public DataModelGenerator withNamingStrategy(@Nonnull String namingStrategyClassName) {
        NamingStrategy namingStrategy = this.getStrategyInstanceFromName(namingStrategyClassName, NamingStrategy.class);
        return this.withNamingStrategy(namingStrategy);
    }

    @Nonnull
    public DataModelGenerator withNameSource(@Nonnull NameSource nameSource) {
        this.nameSource = nameSource;
        return this;
    }

    @Nonnull
    public DataModelGenerator withAnnotationStrategy(@Nonnull AnnotationStrategy annotationStrategy) {
        this.annotationStrategy = annotationStrategy;
        return this;
    }

    @Nonnull
    public DataModelGenerator withAnnotationStrategy(@Nonnull String annotationStrategyClassName) {
        AnnotationStrategy annotationStrategy = this.getStrategyInstanceFromName(annotationStrategyClassName, AnnotationStrategy.class);
        return this.withAnnotationStrategy(annotationStrategy);
    }

    @Nonnull
    public DataModelGenerator failOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
        return this;
    }

    @Nonnull
    public DataModelGenerator failOnWarning() {
        return this.failOnWarning(true);
    }

    @Nonnull
    public DataModelGenerator pojosOnly(boolean pojosOnly) {
        this.generatePojosOnly = pojosOnly;
        return this;
    }

    @Nonnull
    public DataModelGenerator pojosOnly() {
        return this.pojosOnly(true);
    }

    @Nonnull
    public DataModelGenerator serviceMethodsPerEntitySet(boolean serviceMethodsPerEntitySet) {
        this.serviceMethodsPerEntitySet = serviceMethodsPerEntitySet;
        return this;
    }

    @Nonnull
    public DataModelGenerator serviceMethodsPerEntitySet() {
        return this.serviceMethodsPerEntitySet(true);
    }

    @Nonnull
    public DataModelGenerator withExcludeFilePattern(@Nonnull String excludeFilePattern) {
        this.excludeFilePattern = excludeFilePattern;
        return this;
    }

    @Nonnull
    public DataModelGenerator linkToApiBusinessHub(boolean linkToApiBusinessHub) {
        this.generateLinksToApiBusinessHub = linkToApiBusinessHub;
        return this;
    }

    @Nonnull
    public DataModelGenerator linkToApiBusinessHub() {
        return this.linkToApiBusinessHub(true);
    }

    @Nonnull
    public DataModelGenerator versionReference(boolean versionReference) {
        this.generateVersionReference = versionReference;
        return this;
    }

    @Nonnull
    public DataModelGenerator versionReference() {
        return this.versionReference(true);
    }

    @Nonnull
    public DataModelGenerator copyrightHeader(@Nonnull String copyrightHeader) {
        this.copyrightHeader = copyrightHeader;
        return this;
    }

    @Nonnull
    public DataModelGenerator sapCopyrightHeader() {
        return this.copyrightHeader(SAP_COPYRIGHT_HEADER);
    }

    @Nonnull
    public DataModelGenerator withIncludedEntitySets(@Nullable Set<String> includedEntitySets) {
        this.includedEntitySets = includedEntitySets;
        return this;
    }

    @Nonnull
    public DataModelGenerator withIncludedFunctionImports(@Nullable Set<String> includedFunctionImports) {
        this.includedFunctionImports = includedFunctionImports;
        return this;
    }

    @Nonnull
    public DataModelGenerator withIncludedActionImports(@Nullable Set<String> includedActionImports) {
        this.includedActionImports = includedActionImports;
        return this;
    }

    @Nonnull
    public DataModelGenerator withDeprecationNotice(@Nonnull String deprecationNotice) {
        this.deprecationNotice = deprecationNotice;
        return this;
    }

    @Override
    @Nonnull
    public NamingStrategy getNamingStrategy() {
        this.namingStrategy.setNameSource(this.getNameSource());
        return this.namingStrategy;
    }

    public void execute() {
        this.printExecuteInformation();
        new ODataToVdmGenerator().generate(this);
    }

    protected void printExecuteInformation() {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Generating %s with parameters:", this.isGeneratePojosOnly() ? "POJOS ONLY" : "EVERYTHING"));
            String defaultBasePath = this.getDefaultBasePath();
            logger.info("  Input directory:                " + this.getInputDirectory().getAbsolutePath());
            logger.info("  Output directory:               " + this.getOutputDirectory().getAbsolutePath());
            logger.info("  Delete output directory:        " + this.isDeleteTargetDirectory());
            logger.info("  Overwrite files:                " + this.isForceFileOverride());
            logger.info("  Package name:                   " + this.getPackageName());
            logger.info("  Default base path:              " + (defaultBasePath != null ? defaultBasePath : "<none>"));
            logger.info("  Service name mapping file:      " + this.getServiceNameMappings().getAbsolutePath());
            logger.info("  Naming strategy class:          " + this.getNamingStrategy().getClass().getName());
            logger.info("  Name source (default strategy): " + this.getNameSource());
            logger.info("  Annotation strategy class:      " + this.getAnnotationStrategy().getClass().getName());
            logger.info("  Pattern for excluded files:     " + this.getExcludeFilePattern());
            logger.info("  SAP Business Accelerator Hub:   " + this.isGenerateLinksToApiBusinessHub());
            logger.info("  Fail on Warning:                " + this.isFailOnWarning());
            logger.info("  Entity sets to process:         " + (this.includedEntitySets != null && !this.includedEntitySets.isEmpty() ? String.join((CharSequence)", ", this.includedEntitySets) : "<all>"));
            logger.info("  Function imports to process:    " + (this.includedFunctionImports != null && !this.includedFunctionImports.isEmpty() ? String.join((CharSequence)", ", this.includedFunctionImports) : "<all>"));
        }
    }

    private <T> T getStrategyInstanceFromName(String fullyQualifiedClassName, Class<T> expectedInterface) {
        Object strategyInstance;
        try {
            strategyInstance = Class.forName(fullyQualifiedClassName).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ODataGeneratorException("Unable to load specified strategy class. Check the class for errors in its constructor(s) and ensure that security permissions are configured to allow access to the class", e);
        }
        catch (ClassNotFoundException e) {
            throw new ODataGeneratorException("Unable to find specified strategy class. Check that the class is included (directly or via a JAR file) in your classpath list when running Java. Also make sure to enter the fully-qualified class name (e.g. com.myorg.mypath.MyStrategy)", e);
        }
        catch (ClassCastException e) {
            throw new ODataGeneratorException(String.format("Unable to load specified strategy class. Check that the class either implements the %s interface, or extends a class which implements this interface.", expectedInterface.getName()), e);
        }
        return (T)strategyInstance;
    }

    public boolean failureDueToWarningsNecessary() {
        return !MessageCollector.getWarningMessages().isEmpty() && this.failOnWarning;
    }

    @Override
    @Generated
    public File getInputDirectory() {
        return this.inputDirectory;
    }

    @Override
    @Generated
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    @Generated
    public boolean isDeleteTargetDirectory() {
        return this.deleteTargetDirectory;
    }

    @Override
    @Generated
    public boolean isForceFileOverride() {
        return this.forceFileOverride;
    }

    @Override
    @Generated
    public boolean isKeepExistingSignatures() {
        return this.keepExistingSignatures;
    }

    @Override
    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @Generated
    public String getDefaultBasePath() {
        return this.defaultBasePath;
    }

    @Override
    @Generated
    public File getServiceNameMappings() {
        return this.serviceNameMappings;
    }

    @Override
    @Generated
    public NameSource getNameSource() {
        return this.nameSource;
    }

    @Override
    @Generated
    public AnnotationStrategy getAnnotationStrategy() {
        return this.annotationStrategy;
    }

    @Override
    @Generated
    public boolean isGeneratePojosOnly() {
        return this.generatePojosOnly;
    }

    @Override
    @Generated
    public String getExcludeFilePattern() {
        return this.excludeFilePattern;
    }

    @Override
    @Generated
    public boolean isGenerateLinksToApiBusinessHub() {
        return this.generateLinksToApiBusinessHub;
    }

    @Override
    @Generated
    public boolean isGenerateVersionReference() {
        return this.generateVersionReference;
    }

    @Override
    @Generated
    public String getCopyrightHeader() {
        return this.copyrightHeader;
    }

    @Override
    @Generated
    public Set<String> getIncludedEntitySets() {
        return this.includedEntitySets;
    }

    @Override
    @Generated
    public Set<String> getIncludedFunctionImports() {
        return this.includedFunctionImports;
    }

    @Override
    @Generated
    public Set<String> getIncludedActionImports() {
        return this.includedActionImports;
    }

    @Override
    @Generated
    public boolean isServiceMethodsPerEntitySet() {
        return this.serviceMethodsPerEntitySet;
    }

    @Override
    @Generated
    public String getDeprecationNotice() {
        return this.deprecationNotice;
    }

    @Generated
    public boolean isFailOnWarning() {
        return this.failOnWarning;
    }
}

