/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.sap.cloud.sdk.typeconverter.TypeConverter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Arrays;
import javax.annotation.Nonnull;

class FieldFunctionGenerator {
    private final JCodeModel codeModel;

    FieldFunctionGenerator(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    void addFieldFunction(JDefinedClass entityClass, JDefinedClass specificEntityFieldClass) {
        String[] genericStrings = new String[]{"T"};
        JClass[] generics = this.generics(genericStrings);
        JClass returnType = specificEntityFieldClass.narrow(generics[0]);
        JMethod fieldFunc = this.fieldFunction(entityClass, genericStrings, (JType)returnType);
        JVar fieldNameParameter = this.fieldNameParam(fieldFunc);
        JVar fieldTypeParameter = this.fieldTypeParam(generics, fieldFunc);
        this.addJavadoc((JDocCommentable)fieldFunc, fieldNameParameter, fieldTypeParameter, genericStrings[0]);
        this.addReturn((JType)returnType, fieldFunc, (JExpression)fieldNameParameter);
    }

    void addFieldFunctionWithTypeConverter(JDefinedClass entityClass, JDefinedClass specificEntityFieldClass) {
        String[] genericStrings = new String[]{"T", "DomainT"};
        JClass[] generics = this.generics(genericStrings);
        JClass extFieldMethodReturnType = specificEntityFieldClass.narrow(generics[0]);
        JMethod fieldFunc = this.fieldFunction(entityClass, genericStrings, (JType)extFieldMethodReturnType);
        JVar fieldNameParam = this.fieldNameParam(fieldFunc);
        JVar typeConverterParam = this.typeConverterParam(generics, fieldFunc);
        this.addJavadocWithTypeConverter((JDocCommentable)fieldFunc, fieldNameParam, typeConverterParam, genericStrings[0], genericStrings[1]);
        this.addReturnWithTypeConverter((JType)extFieldMethodReturnType, fieldFunc, (JExpression)fieldNameParam, (JExpression)typeConverterParam);
    }

    private JClass[] generics(String ... generics) {
        return (JClass[])Arrays.stream(generics).map(arg_0 -> ((JCodeModel)this.codeModel).directClass(arg_0)).toArray(JClass[]::new);
    }

    private JMethod fieldFunction(JDefinedClass entityClass, String[] genericStrings, JType extFieldMethodReturnType) {
        JMethod fieldFuncWithTypeConverter = entityClass.method(17, extFieldMethodReturnType, "field");
        fieldFuncWithTypeConverter.generify(String.join((CharSequence)",", genericStrings));
        fieldFuncWithTypeConverter.annotate(Nonnull.class);
        return fieldFuncWithTypeConverter;
    }

    private JVar fieldNameParam(JMethod fieldFuncWithTypeConverter) {
        JVar fieldNameParam = fieldFuncWithTypeConverter.param(8, String.class, "fieldName");
        fieldNameParam.annotate(Nonnull.class);
        return fieldNameParam;
    }

    private JVar typeConverterParam(JClass[] generics, JMethod fieldFuncWithTypeConverter) {
        JVar typeConverterParam = fieldFuncWithTypeConverter.param(8, (JType)this.codeModel.ref(TypeConverter.class).narrow(generics), "typeConverter");
        typeConverterParam.annotate(Nonnull.class);
        return typeConverterParam;
    }

    private JVar fieldTypeParam(JClass[] generics, JMethod fieldFunc) {
        JVar fieldTypeParameter = fieldFunc.param(8, (JType)this.codeModel.ref(Class.class).narrow(generics), "fieldType");
        fieldTypeParameter.annotate(Nonnull.class);
        return fieldTypeParameter;
    }

    private void addReturn(JType returnType, JMethod fieldFunc, JExpression fieldNameParameter) {
        fieldFunc.body()._return((JExpression)JExpr._new((JType)returnType).arg(fieldNameParameter));
    }

    private void addReturnWithTypeConverter(JType extFieldMethodReturnType, JMethod fieldFuncWithTypeConverter, JExpression fieldNameParam, JExpression typeConverterParam) {
        fieldFuncWithTypeConverter.body()._return((JExpression)JExpr._new((JType)extFieldMethodReturnType).arg(fieldNameParam).arg(typeConverterParam));
    }

    private void addJavadoc(JDocCommentable fieldFunc, JVar fieldNameParameter, JVar fieldTypeParameter, String genericTypeName) {
        fieldFunc.javadoc().add((Object)"Use with available request builders to apply an extension field to query operations.");
        fieldFunc.javadoc().addReturn().add((Object)"A representation of an extension field from this entity.");
        fieldFunc.javadoc().addParam(fieldNameParameter).add((Object)"The name of the extension field as returned by the OData service.");
        fieldFunc.javadoc().addParam(fieldTypeParameter).add((Object)"The Java type to use for the extension field when performing value comparisons.");
        fieldFunc.javadoc().addParam(this.generify(genericTypeName)).add((Object)"The type of the extension field when performing value comparisons.");
    }

    private void addJavadocWithTypeConverter(JDocCommentable fieldFuncWithTypeConverter, JVar fieldNameParam, JVar typeConverterParam, String genericTypeName, String genericTypeConverterName) {
        fieldFuncWithTypeConverter.javadoc().add((Object)"Use with available request builders to apply an extension field to query operations.");
        fieldFuncWithTypeConverter.javadoc().addReturn().add((Object)"A representation of an extension field from this entity, holding a reference to the given TypeConverter.");
        fieldFuncWithTypeConverter.javadoc().addParam(fieldNameParam).add((Object)"The name of the extension field as returned by the OData service.");
        fieldFuncWithTypeConverter.javadoc().addParam(typeConverterParam).add((Object)"A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field");
        fieldFuncWithTypeConverter.javadoc().addParam(this.generify(genericTypeName)).add((Object)"The type of the extension field when performing value comparisons.");
        fieldFuncWithTypeConverter.javadoc().addParam(this.generify(genericTypeConverterName)).add((Object)"The type of the extension field as returned by the OData service.");
    }

    private String generify(String genericName) {
        return "<" + genericName + ">";
    }
}

