/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.google.common.collect.Multimap;
import com.sap.cloud.sdk.datamodel.odata.utility.EdmxValidator;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingUtils;
import com.sap.cloud.sdk.datamodel.odatav4.generator.AllowedFunctionsResolver;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ApiFunction;
import com.sap.cloud.sdk.datamodel.odatav4.generator.CodeModelClassGenerator;
import com.sap.cloud.sdk.datamodel.odatav4.generator.DataModelGeneratorConfig;
import com.sap.cloud.sdk.datamodel.odatav4.generator.DatamodelMetadataGeneratorAdapter;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EdmService;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EdmxFile;
import com.sap.cloud.sdk.datamodel.odatav4.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorReadException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorWriteException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Service;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ServiceDetails;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ServiceDetailsResolver;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.ODataClientFactory;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.format.ContentType;
import org.slf4j.Logger;
import org.springframework.util.AntPathMatcher;

class ODataToVdmGenerator {
    private static final Logger logger = MessageCollector.getLogger(ODataToVdmGenerator.class);
    private static final String SWAGGER_FILE_EXTENSION_PATTERN = "\\.json$";
    private static final String METADATA_FILE_EXTENSION_PATTERN = "\\.(edmx|xml)$";
    private static final String NAMESPACE_PARENT_PACKAGE_SPACE = "namespaces";
    private static final String SERVICE_PACKAGE_SPACE = "services";
    private static final Charset FILE_ENCODING = StandardCharsets.UTF_8;
    private static final String EDMX_VERSION_ODATA_V4 = "4.0";

    ODataToVdmGenerator() {
    }

    void generate(@Nonnull DataModelGeneratorConfig config) {
        Collection<File> inputFiles;
        Collection<EdmxFile> allEdmxFiles;
        if (!config.getInputDirectory().exists()) {
            throw new ODataGeneratorReadException("The given input directory does not exist: " + this.getCanonicalPath(config.getInputDirectory()));
        }
        if (config.isDeleteTargetDirectory() && config.getOutputDirectory().exists()) {
            this.cleanDirectory(config.getOutputDirectory());
        }
        if ((allEdmxFiles = this.loadServicesFromInput(config, inputFiles = this.getInputFiles(config.getInputDirectory()))).isEmpty()) {
            logger.warn(String.format("No OData service definitions found in the input directory '%s' - exiting.", this.getCanonicalPath(config.getInputDirectory())));
            return;
        }
        Collection allODataServices = allEdmxFiles.stream().filter(EdmxFile::isSuccessfullyParsed).map(edmxFile -> (Service)edmxFile.getService().get()).collect(Collectors.toCollection(ArrayList::new));
        this.storeConfiguration(config.getServiceNameMappings(), allODataServices);
        int numServices = allODataServices.size();
        logger.info("Processing " + numServices + " OData service" + (numServices == 1 ? "" : "s") + "...");
        CodeModelClassGenerator classGenerator = this.createCodeModelForServices(config, allODataServices);
        for (EdmxFile edmxFile2 : allEdmxFiles) {
            if (!edmxFile2.isSuccessfullyParsed() || !classGenerator.wasServiceGenerated((String)edmxFile2.getServiceName().get())) continue;
            edmxFile2.setSuccessfullyGenerated();
        }
        logger.info("Generating Java classes to " + this.getCanonicalPath(config.getOutputDirectory()));
        classGenerator.writeClasses(config, FILE_ENCODING);
        new DatamodelMetadataGeneratorAdapter(logger).generateMetadataIfApplicable(Paths.get(config.getInputDirectory().getAbsolutePath(), new String[0]), Paths.get(config.getOutputDirectory().getAbsolutePath(), new String[0]), allEdmxFiles, classGenerator.getServiceClassGenerator());
    }

    private CodeModelClassGenerator createCodeModelForServices(@Nonnull DataModelGeneratorConfig config, @Nonnull Iterable<Service> allODataServices) {
        String packageName = config.getPackageName();
        String namespaceParentPackageName = this.buildPackageName(packageName, NAMESPACE_PARENT_PACKAGE_SPACE);
        String servicePackageName = this.buildPackageName(packageName, SERVICE_PACKAGE_SPACE);
        CodeModelClassGenerator classGenerator = new CodeModelClassGenerator(config, namespaceParentPackageName, servicePackageName);
        for (Service service : allODataServices) {
            try {
                classGenerator.processService(service, config.getIncludedEntitySets(), config.getIncludedFunctionImports(), config.getIncludedActionImports());
            }
            catch (ODataGeneratorReadException e) {
                logger.warn(String.format("Error in file %s; unable to generate all VDM classes.", service.getName()), (Throwable)e);
            }
        }
        return classGenerator;
    }

    private Collection<EdmxFile> loadServicesFromInput(@Nonnull DataModelGeneratorConfig config, @Nonnull Collection<File> inputFiles) {
        LinkedList<EdmxFile> allEdmxFiles = new LinkedList<EdmxFile>();
        PropertiesConfiguration serviceNameMappings = this.loadPropertiesConfiguration(config.getServiceNameMappings());
        List<CsdlSchema> edmxTerms = ODataToVdmGenerator.loadEdmxSchemas();
        for (File inputFile : inputFiles) {
            if (this.excludePatternMatch(config.getExcludeFilePattern(), inputFile.getName())) {
                logger.info("Skipping EDMX file due to exclusion rule: {}", (Object)inputFile);
                continue;
            }
            if (!EdmxValidator.isQualified((File)inputFile, (EdmxValidator.Version)EdmxValidator.Version.V4)) {
                logger.info("Skipping EDMX file due to incompatible OData version: {}", (Object)inputFile);
                continue;
            }
            String canonicalPath = this.getCanonicalPath(inputFile);
            String servicePath = FilenameUtils.getFullPath((String)canonicalPath);
            String serviceName = FilenameUtils.getBaseName((String)canonicalPath);
            logger.info(String.format("Loading OData service %s", serviceName));
            File serviceSwaggerFile = this.getSwaggerFile(servicePath, serviceName);
            logger.info(String.format("Reading metadata file: %s", canonicalPath));
            logger.info(String.format("Reading swagger file:  %s", this.getCanonicalPath(serviceSwaggerFile)));
            try {
                Service service = this.buildService(serviceName, serviceNameMappings, edmxTerms, config.getDefaultBasePath(), inputFile, serviceSwaggerFile, config.isGenerateLinksToApiBusinessHub());
                allEdmxFiles.add(new EdmxFile(inputFile.toPath(), service));
            }
            catch (ODataGeneratorReadException e) {
                logger.warn(String.format("Error in file %s; unable to generate VDM classes. The file will be skipped and generation continues for the next file.", inputFile.getName()), (Throwable)e);
                allEdmxFiles.add(new EdmxFile(inputFile.toPath(), null));
            }
        }
        return allEdmxFiles;
    }

    @Nullable
    private File getSwaggerFile(@Nonnull String servicePath, @Nonnull String serviceName) {
        String patternText = serviceName + SWAGGER_FILE_EXTENSION_PATTERN;
        Pattern pattern = Pattern.compile(patternText, 2);
        File[] files = new File(servicePath).listFiles((dir, fileName) -> pattern.matcher(fileName).matches());
        return files == null || files.length == 0 ? null : files[0];
    }

    @Nonnull
    private Collection<File> getInputFiles(@Nonnull File inputDir) {
        Pattern pattern = Pattern.compile(".*\\.(edmx|xml)$", 2);
        Predicate<Path> edmxPredicate = p -> pattern.matcher(p.getFileName().toString()).matches();
        return ((Stream)Try.of((CheckedFunction0 & Serializable)() -> Files.walk(inputDir.toPath(), new FileVisitOption[0])).getOrElse(Stream::empty)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(edmxPredicate).map(Path::toFile).collect(Collectors.toList());
    }

    private Service buildService(String serviceName, PropertiesConfiguration serviceNameMappings, List<CsdlSchema> edmxTerms, @Nullable String defaultBasePath, File serviceMetadataFile, File serviceSwaggerFile, boolean linkToApiBusinessHub) {
        Edm metadata = this.getMetadata(serviceMetadataFile, edmxTerms);
        ServiceDetails serviceDetails = new ServiceDetailsResolver(defaultBasePath, FILE_ENCODING).createServiceDetails(serviceMetadataFile, serviceSwaggerFile);
        Multimap<String, ApiFunction> allowedFunctions = new AllowedFunctionsResolver(FILE_ENCODING).findAllowedFunctions(metadata, serviceSwaggerFile);
        EdmService newService = new EdmService(serviceName, serviceNameMappings, metadata, serviceDetails, allowedFunctions, linkToApiBusinessHub);
        logger.info(String.format("  Title: %s", newService.getTitle()));
        logger.info(String.format("  Raw URL: %s", newService.getServiceUrl()));
        logger.info(String.format("  Java Package Name: %s", newService.getJavaPackageName()));
        logger.info(String.format("  Java Class Name: %s", newService.getJavaClassName()));
        return newService;
    }

    private Edm getMetadata(File serviceMetadataFile, List<CsdlSchema> edmxTerms) {
        Edm edm;
        block9: {
            InputStream stream = Files.newInputStream(serviceMetadataFile.toPath(), new OpenOption[0]);
            try {
                ODataClient client = ODataClientFactory.getClient();
                XMLMetadata metadata = client.getDeserializer(ContentType.APPLICATION_XML).toMetadata(stream);
                String edmVersion = metadata.getEdmVersion();
                if (!EDMX_VERSION_ODATA_V4.equals(edmVersion)) {
                    throw new ODataGeneratorReadException("Metadata file being read is not an OData V4 service " + serviceMetadataFile.getPath());
                }
                Map edmxSchemas = metadata.getSchemaByNsOrAlias();
                edm = client.getReader().readMetadata(edmxSchemas, edmxTerms);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ODataGeneratorReadException("Problem reading metadata file " + serviceMetadataFile.getPath(), e);
                }
            }
            stream.close();
        }
        return edm;
    }

    private String buildPackageName(String basePackageName, String subPackageName) {
        if (StringUtils.isBlank((CharSequence)basePackageName)) {
            return subPackageName;
        }
        return String.format("%s.%s", basePackageName, subPackageName);
    }

    private void cleanDirectory(File outputDir) {
        try {
            FileUtils.cleanDirectory((File)outputDir);
        }
        catch (IOException e) {
            throw new ODataGeneratorWriteException(e);
        }
    }

    private PropertiesConfiguration loadPropertiesConfiguration(File serviceMappingsFile) {
        PropertiesConfiguration serviceNameMappings;
        try {
            serviceNameMappings = serviceMappingsFile.exists() ? new PropertiesConfiguration(serviceMappingsFile) : new PropertiesConfiguration();
        }
        catch (ConfigurationException e) {
            throw new ODataGeneratorReadException(e);
        }
        this.sanitizeConfiguration((Configuration)serviceNameMappings);
        return serviceNameMappings;
    }

    static List<CsdlSchema> loadEdmxSchemas() {
        LinkedList<CsdlSchema> termSchemas = new LinkedList<CsdlSchema>();
        Function<String, CsdlTerm> term = name -> new CsdlTerm().setName(name).setType("Edm.String");
        List<CsdlTerm> commonTerms = Arrays.asList(term.apply("Label"), term.apply("QuickInfo"));
        String commonNamespace = "com.sap.vocabularies.Common.v1";
        termSchemas.add(new CsdlSchema().setNamespace("com.sap.vocabularies.Common.v1").setAlias("SAP__common").setTerms(commonTerms));
        termSchemas.add(new CsdlSchema().setNamespace("com.sap.vocabularies.Common.v1").setAlias("Common").setTerms(commonTerms));
        List<CsdlTerm> coreTerms = Arrays.asList(term.apply("LongDescription"), term.apply("Description"));
        termSchemas.add(new CsdlSchema().setNamespace("Org.OData.Core.V1").setAlias("Core").setTerms(coreTerms));
        String[] aliases = new String[]{"Capabilities", "SAP__Capabilities"};
        String[] terms = new String[]{"InsertRestrictions", "UpdateRestrictions", "DeleteRestrictions", "ReadRestrictions"};
        for (String alias : aliases) {
            CsdlSchema schema = new CsdlSchema().setNamespace("Org.OData.Capabilities.V1").setAlias(alias);
            Function<String, CsdlTerm> termer = n -> new CsdlTerm().setName(n).setType(alias + "." + n + "Type");
            termSchemas.add(schema.setTerms(Arrays.stream(terms).map(termer).collect(Collectors.toList())));
        }
        return termSchemas;
    }

    private void sanitizeConfiguration(Configuration configuration) {
        Iterator it = configuration.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.endsWith(".className")) {
                String javaClassName = configuration.getString(key);
                String sanitizedJavaClassName = NamingUtils.serviceNameToBaseJavaClassName((String)javaClassName);
                configuration.setProperty(key, (Object)sanitizedJavaClassName);
            }
            if (!key.endsWith(".packageName")) continue;
            String javaPackageName = configuration.getString(key);
            String sanitizedJavaPackageName = NamingUtils.serviceNameToJavaPackageName((String)javaPackageName);
            configuration.setProperty(key, (Object)sanitizedJavaPackageName);
        }
    }

    private void storeConfiguration(File serviceMappingsFile, Iterable<Service> allODataServices) {
        this.ensureFileExists(serviceMappingsFile);
        PropertiesConfiguration serviceNameMappings = this.loadPropertiesConfiguration(serviceMappingsFile);
        for (Service oDataService : allODataServices) {
            String javaClassNameKey = oDataService.getName() + ".className";
            serviceNameMappings.setProperty(javaClassNameKey, (Object)oDataService.getJavaClassName());
            serviceNameMappings.getLayout().setComment(javaClassNameKey, oDataService.getTitle());
            serviceNameMappings.getLayout().setBlancLinesBefore(javaClassNameKey, 1);
            String javaPackageNameKey = oDataService.getName() + ".packageName";
            serviceNameMappings.setProperty(javaPackageNameKey, (Object)oDataService.getJavaPackageName());
        }
        try {
            serviceNameMappings.save();
        }
        catch (ConfigurationException e) {
            throw new ODataGeneratorWriteException(e);
        }
    }

    private void ensureFileExists(File serviceMappingsFile) {
        if (!serviceMappingsFile.exists()) {
            boolean success;
            if (logger.isInfoEnabled()) {
                logger.info("The service mappings file at '" + this.getCanonicalPath(serviceMappingsFile) + "' does not exist. Creating an empty one.");
            }
            try {
                success = serviceMappingsFile.createNewFile();
            }
            catch (IOException e) {
                throw new ODataGeneratorWriteException(e);
            }
            if (!success) {
                throw new ODataGeneratorWriteException("Could not create service mappings file at '" + this.getCanonicalPath(serviceMappingsFile) + "'");
            }
        }
    }

    private String getCanonicalPath(@Nullable File outputDir) {
        if (outputDir == null) {
            return null;
        }
        try {
            return outputDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ODataGeneratorReadException(e);
        }
    }

    private boolean excludePatternMatch(String excludeFilePattern, String serviceMetadataFilename) {
        ArrayList<String> excludeFilePatternEach = new ArrayList<String>(Arrays.asList(excludeFilePattern.split(",")));
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (String filePattern : excludeFilePatternEach) {
            if (!antPathMatcher.match(filePattern, serviceMetadataFilename)) continue;
            logger.info(String.format("Excluding metadata file %s, as it matches with the excludes pattern.", serviceMetadataFilename));
            return true;
        }
        return false;
    }
}

