/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.sap.cloud.sdk.datamodel.odata.utility.LegacyClassScanner;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingStrategy;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingUtils;
import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CollectionValueActionRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CollectionValueFunctionRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.SingleValueActionRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.SingleValueFunctionRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.generator.DeprecationUtils;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EntityMetadata;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EntityPropertyModel;
import com.sap.cloud.sdk.datamodel.odatav4.generator.NamingContext;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorWriteException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.OperationParameterModel;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Service;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.vavr.control.Option;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import lombok.Generated;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceClassGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceClassGenerator.class);
    private static final String SERVICE_INTERFACE_NAMING = "%sService";
    private static final String SERVICE_IMPLEMENTATION_NAMING = "Default%sService";
    static final String DEFAULT_SERVICE_PATH_FIELD_NAMING = "DEFAULT_SERVICE_PATH";
    private static final String SERVICE_PATH_FIELD_NAMING = "servicePath";
    private static final String BUSINESS_HUB_LINK_TEMPLATE = "<p>Reference: <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/%s?section=OVERVIEW'>SAP Business Accelerator Hub</a></p>";
    private final Map<String, JDefinedClass> generatedServiceInterfaceClasses = new HashMap<String, JDefinedClass>();
    private final Map<String, JDefinedClass> generatedServiceImplementationClasses = new HashMap<String, JDefinedClass>();
    private final Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
    private final JCodeModel codeModel;
    private final JPackage servicePackage;
    private final JPackage namespaceParentPackage;
    private final NamingStrategy codeNamingStrategy;
    private final boolean serviceMethodsPerEntitySet;
    private final LegacyClassScanner classScanner;
    private String customDeprecationNoticeForService = null;

    private void addClassLevelJavadoc(JDocComment javadoc, Service service) {
        Collection<Service.ExternalOverview> additionalDetails;
        if (!Strings.isNullOrEmpty((String)service.getInfoDescription())) {
            String description = this.htmlEscaper.escape(service.getInfoDescription());
            if (!description.matches(".*[.?!]\\s*$")) {
                description = description + ".";
            }
            javadoc.add((Object)String.format("<p>%s</p>", description));
        }
        if (!Strings.isNullOrEmpty((String)service.getExternalUrl())) {
            javadoc.add((Object)String.format("<p><a href='%s'>%s</a></p>", service.getExternalUrl(), Strings.isNullOrEmpty((String)service.getExternalDescription()) ? service.getExternalUrl() : service.getExternalDescription()));
        }
        if (service.hasLinkToApiBusinessHub()) {
            javadoc.add((Object)String.format(BUSINESS_HUB_LINK_TEMPLATE, service.getName()));
        }
        javadoc.add((Object)"<h3>Details:</h3><table summary='Details'>");
        javadoc.add((Object)String.format("<tr><td align='right'>OData Service:</td><td>%s</td></tr>", service.getName()));
        if (!Strings.isNullOrEmpty((String)service.getInfoVersion())) {
            javadoc.add((Object)String.format("<tr><td align='right'>API Version:</td><td>%s</td></tr>", service.getInfoVersion()));
        }
        if (!Strings.isNullOrEmpty((String)service.getMinErpVersion())) {
            javadoc.add((Object)String.format("<tr><td align='right'>Minimum ERP Version:</td><td>%s</td></tr>", service.getMinErpVersion()));
        }
        if ((additionalDetails = service.getExternalOverview()) != null) {
            for (Service.ExternalOverview entry : additionalDetails) {
                if (Strings.isNullOrEmpty((String)entry.getName()) || entry.getValues() == null) continue;
                javadoc.add((Object)String.format("<tr><td align='right'>%s:</td><td>%s</td></tr>", entry.getName(), Joiner.on((String)", ").join(entry.getValues())));
            }
        }
        javadoc.add((Object)"</table>");
    }

    private JDefinedClass generateServiceInterface(Service service, String formattedInterfaceName) throws JClassAlreadyExistsException {
        JDefinedClass interfaceClass = this.servicePackage._interface(formattedInterfaceName);
        this.addClassLevelJavadoc(interfaceClass.javadoc(), service);
        JFieldVar defaultServicePathField = interfaceClass.field(0, String.class, DEFAULT_SERVICE_PATH_FIELD_NAMING, JExpr.lit((String)service.getServiceUrl()));
        defaultServicePathField.javadoc().add((Object)"If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path used to access the endpoint.");
        DeprecationUtils.addStatusInformation(interfaceClass, service, this.customDeprecationNoticeForService);
        JMethod withServicePathMethod = interfaceClass.method(0, (JType)interfaceClass, "withServicePath");
        withServicePathMethod.annotate(Nonnull.class);
        JVar servicePathParam = withServicePathMethod.param(8, String.class, SERVICE_PATH_FIELD_NAMING);
        servicePathParam.annotate(Nonnull.class);
        withServicePathMethod.javadoc().add((Object)"Overrides the default service path and returns a new service instance with the specified service path. Also adjusts the respective entity URLs.");
        withServicePathMethod.javadoc().addParam(servicePathParam).add((Object)"Service path that will override the default.");
        withServicePathMethod.javadoc().addReturn().add((Object)"A new service instance with the specified service path.");
        this.addBatchInterfaceMethod(interfaceClass);
        return interfaceClass;
    }

    private void addBatchInterfaceMethod(JDefinedClass serviceInterfaceClass) {
        JClass batchRequestBuilder = this.codeModel.ref(BatchRequestBuilder.class);
        String methodName = "batch";
        JMethod interfaceMethod = serviceInterfaceClass.method(0, (JType)batchRequestBuilder, "batch");
        interfaceMethod.annotate(Nonnull.class);
        interfaceMethod.javadoc().add((Object)String.format("Creates a batch request builder object.", new Object[0]));
        interfaceMethod.javadoc().addReturn().add((Object)String.format("A request builder to handle batch operation on this service. To perform execution, call the {@link %s#execute(HttpDestinationProperties) execute} method on the request builder object.", batchRequestBuilder.fullName()));
    }

    private JDefinedClass generateServiceImplementation(JDefinedClass serviceInterfaceClass, Service service, String formattedClassName) throws JClassAlreadyExistsException {
        JDefinedClass serviceClass = this.servicePackage._class(formattedClassName)._implements((JClass)serviceInterfaceClass);
        serviceClass.annotate(Named.class).param("value", this.servicePackage.name() + "." + formattedClassName);
        this.addClassLevelJavadoc(serviceClass.javadoc(), service);
        DeprecationUtils.addStatusInformation(serviceClass, service, this.customDeprecationNoticeForService);
        JFieldVar servicePathField = serviceClass.field(12, String.class, SERVICE_PATH_FIELD_NAMING);
        servicePathField.annotate(Nonnull.class);
        serviceClass._implements(ServiceWithNavigableEntities.class);
        servicePathField.annotate(Getter.class);
        JMethod noArgsConstructor = serviceClass.constructor(1);
        noArgsConstructor.body().assign((JAssignmentTarget)JExpr.ref((String)SERVICE_PATH_FIELD_NAMING), (JExpression)serviceInterfaceClass.staticRef(DEFAULT_SERVICE_PATH_FIELD_NAMING));
        noArgsConstructor.javadoc().add((Object)String.format("Creates a service using {@link %s#%s} to send the requests.", serviceInterfaceClass.name(), DEFAULT_SERVICE_PATH_FIELD_NAMING));
        JMethod servicePathConstructor = serviceClass.constructor(4);
        JVar servicePathParameter = servicePathConstructor.param(8, String.class, SERVICE_PATH_FIELD_NAMING);
        servicePathParameter.annotate(Nonnull.class);
        servicePathConstructor.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)servicePathField), (JExpression)servicePathParameter);
        servicePathConstructor.javadoc().add((Object)"Creates a service using the provided service path to send the requests.\n");
        servicePathConstructor.javadoc().add((Object)"<p>\n");
        servicePathConstructor.javadoc().add((Object)"Used by the fluent {@link #withServicePath(String)} method.");
        JMethod withServicePathMethod = serviceClass.method(1, (JType)serviceClass, "withServicePath");
        withServicePathMethod.annotate(Override.class);
        withServicePathMethod.annotate(Nonnull.class);
        JVar servicePathParam = withServicePathMethod.param(8, String.class, SERVICE_PATH_FIELD_NAMING);
        servicePathParam.annotate(Nonnull.class);
        withServicePathMethod.body()._return((JExpression)JExpr._new((JClass)serviceClass).arg((JExpression)servicePathParam));
        this.addBatchImplementationMethod(serviceClass);
        return serviceClass;
    }

    private void addBatchImplementationMethod(JDefinedClass serviceImplementationClass) {
        JClass batchRequestBuilder = this.codeModel.ref(BatchRequestBuilder.class);
        String methodName = "batch";
        JMethod implementationMethod = serviceImplementationClass.method(1, (JType)batchRequestBuilder, "batch");
        implementationMethod.annotate(Override.class);
        implementationMethod.annotate(Nonnull.class);
        implementationMethod.body()._return((JExpression)JExpr._new((JType)batchRequestBuilder).arg((JExpression)JExpr.ref((String)SERVICE_PATH_FIELD_NAMING)));
    }

    JDefinedClass getOrGenerateServiceInterfaceClass(Service service) {
        String formattedInterfaceName = String.format(SERVICE_INTERFACE_NAMING, service.getJavaClassName());
        JDefinedClass interfaceClass = this.generatedServiceInterfaceClasses.get(service.getName());
        if (interfaceClass == null) {
            try {
                interfaceClass = this.generateServiceInterface(service, formattedInterfaceName);
            }
            catch (JClassAlreadyExistsException e) {
                log.error("Failed to get or generate interface: {} for service: {}", (Object)formattedInterfaceName, (Object)service);
                this.generatedServiceInterfaceClasses.entrySet().stream().filter(entry -> ((JDefinedClass)entry.getValue()).name().equals(formattedInterfaceName)).map(Map.Entry::getKey).findFirst().ifPresent(s -> log.error("An interface with the same name was already defined by service: {}", s));
                throw new ODataGeneratorException(e);
            }
            this.generatedServiceInterfaceClasses.put(service.getName(), interfaceClass);
        }
        return interfaceClass;
    }

    JDefinedClass getOrGenerateServiceImplementationClass(Service service, JDefinedClass interfaceClass) {
        String formattedClassName = String.format(SERVICE_IMPLEMENTATION_NAMING, service.getJavaClassName());
        JDefinedClass implementationClass = this.generatedServiceImplementationClasses.get(service.getName());
        if (implementationClass == null) {
            try {
                implementationClass = this.generateServiceImplementation(interfaceClass, service, formattedClassName);
            }
            catch (JClassAlreadyExistsException e) {
                log.error("Failed to get or generate class:{} for service: {}", (Object)formattedClassName, (Object)service.getName());
                this.generatedServiceImplementationClasses.entrySet().stream().filter(entry -> ((JDefinedClass)entry.getValue()).name().equals(formattedClassName)).map(Map.Entry::getKey).findFirst().ifPresent(s -> log.error("A class with the same name was already defined by service: {}", s));
                throw new ODataGeneratorException(e);
            }
            this.generatedServiceImplementationClasses.put(service.getName(), implementationClass);
        }
        return implementationClass;
    }

    ServiceClassAmplifier getOrGenerateServiceClassesAndGetAmplifier(Service service) {
        JDefinedClass serviceInterfaceClass = this.getOrGenerateServiceInterfaceClass(service);
        JDefinedClass serviceImplementationClass = this.getOrGenerateServiceImplementationClass(service, serviceInterfaceClass);
        return new ServiceClassAmplifier(serviceInterfaceClass, serviceImplementationClass, this.codeNamingStrategy, this.codeModel, this.serviceMethodsPerEntitySet, this.classScanner);
    }

    private static String getMethodNameSuffixFromEntitySet(String entitySetName) {
        return StringUtils.removeStartIgnoreCase((String)entitySetName, (String)"A_");
    }

    Option<String> getQualifiedServiceInterfaceName(String serviceName) {
        return Option.of((Object)this.generatedServiceInterfaceClasses.get(serviceName)).map(JDefinedClass::fullName);
    }

    Option<String> getQualifiedServiceImplementationClassName(String serviceName) {
        return Option.of((Object)this.generatedServiceImplementationClasses.get(serviceName)).map(JDefinedClass::fullName);
    }

    boolean wasServiceGenerated(String serviceName) {
        return this.generatedServiceInterfaceClasses.containsKey(serviceName);
    }

    @Generated
    public ServiceClassGenerator(JCodeModel codeModel, JPackage servicePackage, JPackage namespaceParentPackage, NamingStrategy codeNamingStrategy, boolean serviceMethodsPerEntitySet, LegacyClassScanner classScanner) {
        this.codeModel = codeModel;
        this.servicePackage = servicePackage;
        this.namespaceParentPackage = namespaceParentPackage;
        this.codeNamingStrategy = codeNamingStrategy;
        this.serviceMethodsPerEntitySet = serviceMethodsPerEntitySet;
        this.classScanner = classScanner;
    }

    @Generated
    void setCustomDeprecationNoticeForService(String customDeprecationNoticeForService) {
        this.customDeprecationNoticeForService = customDeprecationNoticeForService;
    }

    static final class ServiceClassAmplifier {
        private final JDefinedClass serviceInterfaceClass;
        private final JDefinedClass serviceImplementationClass;
        private final NamingStrategy codeNamingStrategy;
        private final JCodeModel codeModel;
        private final boolean serviceMethodsPerEntitySet;
        private final LegacyClassScanner classScanner;

        Iterable<EntityPropertyModel> getRefinedKeyProperties(@Nonnull String methodName, @Nonnull Iterable<EntityPropertyModel> keyProperties) {
            List getByKeyMethodArguments = this.classScanner.determineArgumentsForMethod(this.serviceInterfaceClass.fullName(), methodName, keyProperties, EntityPropertyModel::getJavaFieldName);
            if (getByKeyMethodArguments.size() != 1) {
                String msg = String.format("Entity in class %s has different key parameters than last time the code generator run.", this.serviceInterfaceClass.fullName());
                log.error("{} Found the following key parameter groups: {}", (Object)msg, (Object)getByKeyMethodArguments);
                throw new ODataGeneratorWriteException(msg);
            }
            return (Iterable)getByKeyMethodArguments.get(0);
        }

        String getByKeyMethodName(EntityMetadata entityMetadata) {
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityMetadata.getGeneratedEntityClass().name();
            return NamingUtils.deriveGetEntityServiceMethodName((String)methodNameSuffix);
        }

        void addGetByKeyMethod(EntityMetadata entityMetadata, String methodName, Iterable<EntityPropertyModel> keyProperties) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            JClass getByKeyRequestBuilder = this.codeModel.ref(GetByKeyRequestBuilder.class).narrow((JClass)entityClass);
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)getByKeyRequestBuilder, methodName);
            interfaceMethod.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Fetch a single {@link %s %s} entity using key fields.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A request builder to fetch a single {@link %s %s} entity using key fields. This request builder allows methods which modify the underlying query to be called before executing the query itself. To perform execution, call the {@link %s#execute execute} method on the request builder object. ", entityClass.fullName(), entityClass.name(), getByKeyRequestBuilder.fullName()));
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)getByKeyRequestBuilder, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            HashMap<String, JVar> generatedParameters = new HashMap<String, JVar>();
            for (EntityPropertyModel keyProperty : keyProperties) {
                JVar interfaceKeyParameter = interfaceMethod.param(8, (JType)keyProperty.getJavaFieldClass(), keyProperty.getJavaFieldName());
                JCommentPart parameterJavadoc = interfaceMethod.javadoc().addParam(interfaceKeyParameter);
                parameterJavadoc.add((Object)keyProperty.getBasicDescription());
                if (!Strings.isNullOrEmpty((String)keyProperty.getConstraintsDescription())) {
                    parameterJavadoc.add((Object)String.format("<p>%s</p>", keyProperty.getConstraintsDescription()));
                }
                JVar implementationKeyParameter = implementationMethod.param(8, (JType)keyProperty.getJavaFieldClass(), keyProperty.getJavaFieldName());
                generatedParameters.put(keyProperty.getJavaFieldName(), implementationKeyParameter);
            }
            JClass keyType = this.codeModel.ref(String.class);
            JClass valueType = this.codeModel.ref(Object.class);
            JVar key = implementationMethod.body().decl(8, (JType)this.codeModel.ref(Map.class).narrow(new JClass[]{keyType, valueType}), "key", (JExpression)JExpr._new((JClass)this.codeModel.ref(HashMap.class).narrow(new JClass[]{keyType, valueType})));
            for (EntityPropertyModel model : keyProperties) {
                implementationMethod.body().add((JStatement)key.invoke("put").arg(model.getEdmName()).arg((JExpression)generatedParameters.get(model.getJavaFieldName())));
            }
            JInvocation methodBody = JExpr._new((JType)getByKeyRequestBuilder).arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg(entityClass.dotclass()).arg((JExpression)key).arg(entityMetadata.getEntitySetName());
            implementationMethod.body()._return((JExpression)methodBody);
        }

        void addGetAllMethod(EntityMetadata entityMetadata) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            JClass getAllRequestBuilder = this.codeModel.ref(GetAllRequestBuilder.class).narrow((JClass)entityClass);
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityClass.name();
            String methodName = NamingUtils.deriveGetAllEntitiesServiceMethodName((String)methodNameSuffix);
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)getAllRequestBuilder, methodName);
            interfaceMethod.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Fetch multiple {@link %s %s} entities.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A request builder to fetch multiple {@link %s %s} entities. This request builder allows methods which modify the underlying query to be called before executing the query itself. To perform execution, call the {@link %s#execute execute} method on the request builder object. ", entityClass.fullName(), entityClass.name(), getAllRequestBuilder.fullName()));
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)getAllRequestBuilder, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            JInvocation methodBody = JExpr._new((JClass)getAllRequestBuilder).arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg(entityClass.dotclass()).arg(entityMetadata.getEntitySetName());
            implementationMethod.body()._return((JExpression)methodBody);
        }

        void addCountMethod(EntityMetadata entityMetadata) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            JClass countRequestBuilder = this.codeModel.ref(CountRequestBuilder.class).narrow((JClass)entityClass);
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityClass.name();
            String methodName = NamingUtils.deriveCountEntitiesServiceMethodName((String)methodNameSuffix);
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)countRequestBuilder, methodName);
            interfaceMethod.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Fetch the number of entries from the {@link %s %s} entity collection matching the filter and search expressions.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A request builder to fetch the count of {@link %s %s} entities. This request builder allows methods which modify the underlying query to be called before executing the query itself. To perform execution, call the {@link %s#execute execute} method on the request builder object. ", entityClass.fullName(), entityClass.name(), countRequestBuilder.fullName()));
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)countRequestBuilder, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            JInvocation methodBody = JExpr._new((JClass)countRequestBuilder).arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg(entityClass.dotclass()).arg(entityMetadata.getEntitySetName());
            implementationMethod.body()._return((JExpression)methodBody);
        }

        void addUnboundOperation(String edmName, String edmLabel, String description, List<OperationParameterModel> parameters, NamingContext functionImportFetchMethodNamingContext, boolean isCollectionReturnType, JClass javaReturnType, boolean isFunction) {
            String methodNameFetch = functionImportFetchMethodNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaOperationMethodName(edmName, edmLabel));
            Class unboundOperationRequestBuilder = isFunction ? (isCollectionReturnType ? CollectionValueFunctionRequestBuilder.class : SingleValueFunctionRequestBuilder.class) : (isCollectionReturnType ? CollectionValueActionRequestBuilder.class : SingleValueActionRequestBuilder.class);
            List unboundOperationFactoryMethods = this.classScanner.determineArgumentsForMethod(this.serviceInterfaceClass.fullName(), methodNameFetch, parameters, OperationParameterModel::getJavaName);
            for (List factoryMethodArguments : unboundOperationFactoryMethods) {
                JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)this.codeModel.ref(unboundOperationRequestBuilder).narrow(javaReturnType), methodNameFetch);
                interfaceMethod.annotate(Nonnull.class);
                interfaceMethod.javadoc().add((Object)(Strings.isNullOrEmpty((String)description) ? "" : description));
                String operation = isFunction ? "function" : "action";
                interfaceMethod.javadoc().add((Object)String.format("<p>Creates a request builder for the <b>%s</b> OData %s.</p>", edmName, operation));
                interfaceMethod.javadoc().addReturn().add((Object)String.format("A request builder object that will execute the <b>%s</b> OData %s with the provided parameters. To perform execution, call the {@link %s#execute execute} method on the request builder object.", edmName, operation, unboundOperationRequestBuilder.getName()));
                JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)this.codeModel.ref(unboundOperationRequestBuilder).narrow(javaReturnType), methodNameFetch);
                implementationMethod.annotate(Override.class);
                implementationMethod.annotate(Nonnull.class);
                JInvocation newHelperStatement = JExpr._new((JClass)this.codeModel.ref(unboundOperationRequestBuilder).narrow(javaReturnType));
                newHelperStatement.arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING));
                newHelperStatement.arg(edmName);
                JVar functionParameters = null;
                if (!parameters.isEmpty()) {
                    JClass fieldMapClass = this.codeModel.ref(LinkedHashMap.class).narrow(new Class[]{String.class, Object.class});
                    functionParameters = implementationMethod.body().decl(8, (JType)fieldMapClass, "parameters", (JExpression)JExpr._new((JClass)this.codeModel.ref(LinkedHashMap.class).narrow(new Class[]{String.class, Object.class})));
                    newHelperStatement.arg((JExpression)functionParameters);
                }
                for (OperationParameterModel parameter : factoryMethodArguments) {
                    JVar interfaceParameter = interfaceMethod.param(8, parameter.getJavaType(), parameter.getJavaName());
                    JCommentPart parameterDoc = interfaceMethod.javadoc().addParam(interfaceParameter);
                    if (!Strings.isNullOrEmpty((String)parameter.getDescription())) {
                        parameterDoc.add((Object)parameter.getDescription());
                    }
                    JVar implementationParameter = implementationMethod.param(8, parameter.getJavaType(), parameter.getJavaName());
                    implementationMethod.body().invoke((JExpression)functionParameters, "put").arg(parameter.getEdmName()).arg((JExpression)implementationParameter);
                    Class parameterAnnotationClass = parameter.isNullable() ? Nullable.class : Nonnull.class;
                    interfaceParameter.annotate(parameterAnnotationClass);
                    implementationParameter.annotate(parameterAnnotationClass);
                }
                newHelperStatement.arg(javaReturnType.dotclass());
                implementationMethod.body()._return((JExpression)newHelperStatement);
            }
        }

        void addCreateMethod(EntityMetadata entityMetadata) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            JClass createRequestBuilder = this.codeModel.ref(CreateRequestBuilder.class).narrow((JClass)entityClass);
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityClass.name();
            String methodName = NamingUtils.deriveCreateEntityServiceMethodName((String)methodNameSuffix);
            String parameterName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, entityClass.name());
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)createRequestBuilder, methodName);
            interfaceMethod.annotate(Nonnull.class);
            JVar interfaceEntityParam = interfaceMethod.param(8, (JType)entityClass, parameterName);
            interfaceEntityParam.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Create a new {@link %s %s} entity and save it to the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addParam(interfaceEntityParam).add((Object)String.format("{@link %s %s} entity object that will be created in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A request builder to create a new {@link %s %s} entity. To perform execution, call the {@link %s#execute execute} method on the request builder object. ", entityClass.fullName(), entityClass.name(), createRequestBuilder.fullName()));
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)createRequestBuilder, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            JVar implementationEntityParam = implementationMethod.param(8, (JType)entityClass, parameterName);
            implementationEntityParam.annotate(Nonnull.class);
            JInvocation methodBody = JExpr._new((JType)createRequestBuilder).arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg((JExpression)implementationEntityParam).arg(entityMetadata.getEntitySetName());
            implementationMethod.body()._return((JExpression)methodBody);
        }

        void addUpdateMethod(EntityMetadata entityMetadata) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            JClass updateRequestBuilder = this.codeModel.ref(UpdateRequestBuilder.class).narrow((JClass)entityClass);
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityClass.name();
            String methodName = NamingUtils.deriveUpdateEntityServiceMethodName((String)methodNameSuffix);
            String parameterName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, entityClass.name());
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)updateRequestBuilder, methodName);
            interfaceMethod.annotate(Nonnull.class);
            JVar interfaceEntityParam = interfaceMethod.param(8, (JType)entityClass, parameterName);
            interfaceEntityParam.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Update an existing {@link %s %s} entity and save it to the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addParam(interfaceEntityParam).add((Object)String.format("{@link %s %s} entity object that will be updated in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A request builder to update an existing {@link %s %s} entity. To perform execution, call the {@link %s#execute execute} method on the request builder object. ", entityClass.fullName(), entityClass.name(), updateRequestBuilder.fullName()));
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)updateRequestBuilder, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            JVar implementationEntityParam = implementationMethod.param(8, (JType)entityClass, parameterName);
            implementationEntityParam.annotate(Nonnull.class);
            JInvocation methodBody = JExpr._new((JType)updateRequestBuilder).arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg((JExpression)implementationEntityParam).arg(entityMetadata.getEntitySetName());
            implementationMethod.body()._return((JExpression)methodBody);
        }

        void addDeleteMethod(EntityMetadata entityMetadata) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            JClass deleteRequestBuilder = this.codeModel.ref(DeleteRequestBuilder.class).narrow((JClass)entityClass);
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityClass.name();
            String methodName = NamingUtils.deriveDeleteEntityServiceMethodName((String)methodNameSuffix);
            String parameterName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, entityClass.name());
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)deleteRequestBuilder, methodName);
            interfaceMethod.annotate(Nonnull.class);
            JVar interfaceEntityParam = interfaceMethod.param(8, (JType)entityClass, parameterName);
            interfaceEntityParam.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Deletes an existing {@link %s %s} entity in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addParam(interfaceEntityParam).add((Object)String.format("{@link %s %s} entity object that will be deleted in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A request builder to delete an existing {@link %s %s} entity. To perform execution, call the {@link %s#execute execute} method on the request builder object. ", entityClass.fullName(), entityClass.name(), deleteRequestBuilder.fullName()));
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)deleteRequestBuilder, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            JVar implementationEntityParam = implementationMethod.param(8, (JType)entityClass, parameterName);
            implementationEntityParam.annotate(Nonnull.class);
            JInvocation methodBody = JExpr._new((JType)deleteRequestBuilder).arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg((JExpression)implementationEntityParam).arg(entityMetadata.getEntitySetName());
            implementationMethod.body()._return((JExpression)methodBody);
        }

        @Generated
        public ServiceClassAmplifier(JDefinedClass serviceInterfaceClass, JDefinedClass serviceImplementationClass, NamingStrategy codeNamingStrategy, JCodeModel codeModel, boolean serviceMethodsPerEntitySet, LegacyClassScanner classScanner) {
            this.serviceInterfaceClass = serviceInterfaceClass;
            this.serviceImplementationClass = serviceImplementationClass;
            this.codeNamingStrategy = codeNamingStrategy;
            this.codeModel = codeModel;
            this.serviceMethodsPerEntitySet = serviceMethodsPerEntitySet;
            this.classScanner = classScanner;
        }

        @Generated
        JDefinedClass getServiceInterfaceClass() {
            return this.serviceInterfaceClass;
        }
    }
}

