/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.sap.cloud.sdk.cloudplatform.util.StringUtils;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ApiFunction;
import com.sap.cloud.sdk.datamodel.odatav4.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorReadException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmPropertyValue;
import org.slf4j.Logger;

class AllowedFunctionsResolver {
    private static final Logger logger = MessageCollector.getLogger(AllowedFunctionsResolver.class);
    private static final String[] TERMS_READ_RESTRICTIONS = new String[]{"Capabilities.ReadRestrictions", "SAP__capabilities.ReadRestrictions"};
    private static final String[] TERMS_INSERT_RESTRICTIONS = new String[]{"Capabilities.InsertRestrictions", "SAP__capabilities.InsertRestrictions"};
    private static final String[] TERMS_UPDATE_RESTRICTIONS = new String[]{"Capabilities.UpdateRestrictions", "SAP__capabilities.UpdateRestrictions"};
    private static final String[] TERMS_DELETE_RESTRICTIONS = new String[]{"Capabilities.DeleteRestrictions", "SAP__capabilities.DeleteRestrictions"};
    private static final String PROPERTY_READ_BY_KEY = "ReadByKeyRestrictions";
    private static final String PROPERTY_READABLE = "Readable";
    private static final String PROPERTY_INSERTABLE = "Insertable";
    private static final String PROPERTY_UPDATABLE = "Updatable";
    private static final String PROPERTY_DELETABLE = "Deletable";
    private final Charset encoding;

    AllowedFunctionsResolver(Charset encoding) {
        this.encoding = encoding;
    }

    @Nonnull
    Multimap<String, ApiFunction> findAllowedFunctions(@Nonnull Edm metadata, @Nullable File swaggerFile) {
        Multimap<String, ApiFunction> allowedFunctionsByEntity = null;
        if (swaggerFile != null && swaggerFile.exists()) {
            allowedFunctionsByEntity = this.readFromSwaggerFile(swaggerFile);
        } else if (swaggerFile != null) {
            logger.debug("Could not find swagger file at {}. Trying to read the allowed functions from the metadata file.", (Object)swaggerFile.getAbsolutePath());
        } else {
            logger.debug("No swagger file given. Trying to read the allowed functions from the metadata file.");
        }
        if (allowedFunctionsByEntity == null) {
            allowedFunctionsByEntity = this.readFromMetadata(metadata);
        }
        return allowedFunctionsByEntity;
    }

    private Multimap<String, ApiFunction> readFromSwaggerFile(File swaggerFile) {
        SetMultimap allowedFunctionsByEntity = MultimapBuilder.hashKeys().hashSetValues().build();
        Iterable<Map.Entry<String, JsonElement>> paths = this.readPaths(swaggerFile);
        for (Map.Entry<String, JsonElement> pathsEntry : paths) {
            this.handleSwaggerPath((Multimap<String, ApiFunction>)allowedFunctionsByEntity, pathsEntry);
        }
        return allowedFunctionsByEntity.isEmpty() ? null : allowedFunctionsByEntity;
    }

    private Iterable<Map.Entry<String, JsonElement>> readPaths(File swaggerFile) {
        Set set;
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(swaggerFile.toPath(), new OpenOption[0]), this.encoding);
        try {
            JsonElement swaggerJson = JsonParser.parseReader((Reader)reader);
            set = swaggerJson.getAsJsonObject().get("paths").getAsJsonObject().entrySet();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ODataGeneratorReadException(e);
            }
        }
        ((Reader)reader).close();
        return set;
    }

    private void handleSwaggerPath(Multimap<String, ApiFunction> allowedFunctionsByEntity, Map.Entry<String, JsonElement> pathsEntry) {
        String pathEntry = pathsEntry.getKey();
        String[] split = Objects.requireNonNull(StringUtils.removeStartIgnoreCase((String)pathEntry, (String)"/")).split("\\(");
        String pathEntitySet = split[0];
        allowedFunctionsByEntity.put((Object)pathEntitySet, (Object)ApiFunction.NAVIGATE);
        block22: for (Map.Entry entry : pathsEntry.getValue().getAsJsonObject().entrySet()) {
            switch ((String)entry.getKey()) {
                case "get": {
                    if (split.length > 1) {
                        allowedFunctionsByEntity.put((Object)pathEntitySet, (Object)ApiFunction.READ_BY_KEY);
                        continue block22;
                    }
                    allowedFunctionsByEntity.put((Object)pathEntitySet, (Object)ApiFunction.READ);
                    continue block22;
                }
                case "post": {
                    allowedFunctionsByEntity.put((Object)pathEntitySet, (Object)ApiFunction.CREATE);
                    continue block22;
                }
                case "patch": {
                    allowedFunctionsByEntity.put((Object)pathEntitySet, (Object)ApiFunction.UPDATE);
                    continue block22;
                }
                case "delete": {
                    allowedFunctionsByEntity.put((Object)pathEntitySet, (Object)ApiFunction.DELETE);
                    continue block22;
                }
                case "put": 
                case "options": 
                case "head": 
                case "trace": {
                    logger.warn("Skipping unsupported operation '" + (String)entry.getKey() + "'.");
                    continue block22;
                }
                case "summary": 
                case "description": 
                case "parameters": 
                case "servers": {
                    logger.debug("Skipping field '" + (String)entry.getKey() + "' from the Swagger file.");
                    continue block22;
                }
            }
            logger.info("Skipping unexpected field " + (String)entry.getKey() + "' from Swagger file.");
        }
    }

    private Multimap<String, ApiFunction> readFromMetadata(Edm metadata) {
        SetMultimap allowedFunctionsByEntity = MultimapBuilder.hashKeys().hashSetValues().build();
        for (EdmEntitySet entitySet : metadata.getEntityContainer().getEntitySetsWithAnnotations()) {
            String entitySetName = entitySet.getName();
            allowedFunctionsByEntity.put((Object)entitySetName, (Object)ApiFunction.NAVIGATE);
            if (this.isEntitySetReadableByKey(metadata, entitySet)) {
                allowedFunctionsByEntity.put((Object)entitySetName, (Object)ApiFunction.READ_BY_KEY);
            }
            if (this.isEntitySetOperationPermitted(entitySet, TERMS_READ_RESTRICTIONS, PROPERTY_READABLE)) {
                allowedFunctionsByEntity.put((Object)entitySetName, (Object)ApiFunction.READ);
            }
            if (this.isEntitySetOperationPermitted(entitySet, TERMS_INSERT_RESTRICTIONS, PROPERTY_INSERTABLE)) {
                allowedFunctionsByEntity.put((Object)entitySetName, (Object)ApiFunction.CREATE);
            }
            if (this.isEntitySetOperationPermitted(entitySet, TERMS_UPDATE_RESTRICTIONS, PROPERTY_UPDATABLE)) {
                allowedFunctionsByEntity.put((Object)entitySetName, (Object)ApiFunction.UPDATE);
            }
            if (!this.isEntitySetOperationPermitted(entitySet, TERMS_DELETE_RESTRICTIONS, PROPERTY_DELETABLE)) continue;
            allowedFunctionsByEntity.put((Object)entitySetName, (Object)ApiFunction.DELETE);
        }
        return allowedFunctionsByEntity;
    }

    private boolean isEntitySetOperationPermitted(EdmEntitySet entitySet, String[] termNames, String propertyName) {
        Collector fqnMapper = Collectors.toMap(annotation -> annotation.getTerm().getFullQualifiedName().toString(), Function.identity());
        Map annotations = entitySet.getAnnotations().stream().filter(annotation -> annotation.getTerm() != null).collect(fqnMapper);
        for (String termFqn : termNames) {
            EdmAnnotation annotation2 = (EdmAnnotation)annotations.get(termFqn);
            if (annotation2 == null) continue;
            EdmPropertyValue edmPropertyValue = this.getEdmPropertyValue(annotation2.getExpression(), propertyName);
            Boolean operationFlag = this.getBooleanFromPropertyValue(edmPropertyValue);
            if (operationFlag != null) {
                return operationFlag;
            }
            logger.warn(String.format("Annotation %s of entity set %s is in an unexpected format. Unable to determine if %s operation is permitted.", termFqn, entitySet.getName(), propertyName));
        }
        return true;
    }

    private boolean isEntitySetReadableByKey(Edm metadata, EdmEntitySet entitySet) {
        for (String termFqn : TERMS_READ_RESTRICTIONS) {
            EdmPropertyValue readByKeyProperty;
            EdmTerm term = metadata.getTerm(new FullQualifiedName(termFqn));
            EdmAnnotation annotation = (EdmAnnotation)Try.of((CheckedFunction0 & Serializable)() -> entitySet.getAnnotation(term, null)).getOrNull();
            if (annotation == null || (readByKeyProperty = this.getEdmPropertyValue(annotation.getExpression(), PROPERTY_READ_BY_KEY)) == null) continue;
            EdmPropertyValue edmPropertyValue = this.getEdmPropertyValue(readByKeyProperty.getValue(), PROPERTY_READABLE);
            Boolean operationFlag = this.getBooleanFromPropertyValue(edmPropertyValue);
            if (operationFlag != null) {
                return operationFlag;
            }
            logger.warn(String.format("Annotation %s of entity set %s is in an unexpected format. Unable to determine if reading by key is enabled.", termFqn, entitySet.getName()));
        }
        return true;
    }

    private EdmPropertyValue getEdmPropertyValue(EdmExpression expression, String propertyName) {
        if (expression != null && expression.isDynamic() && expression.asDynamic().isRecord()) {
            List propertyValues = expression.asDynamic().asRecord().getPropertyValues();
            for (EdmPropertyValue pv : propertyValues) {
                if (!pv.getProperty().equals(propertyName)) continue;
                return pv;
            }
        }
        return null;
    }

    private Boolean getBooleanFromPropertyValue(EdmPropertyValue propertyValue) {
        if (propertyValue != null && propertyValue.getValue() != null && propertyValue.getValue().isConstant()) {
            try {
                Object value = propertyValue.getValue().asConstant().asPrimitive();
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }
}

